/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMacerator;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class TileEntityMacerator
extends TileEntityInventory
implements IUpdateTick,
IAudioFixer {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.25, 1.0));
    public final InvSlotRecipes inputSlotA;
    public final InvSlotOutput outputSlot;
    public int progress = 0;
    public MachineRecipe output;
    public int durability = 96;
    public Map<UUID, Double> data = PrimitiveHandler.getPlayersData(EnumPrimitive.MACERATOR);

    public TileEntityMacerator() {
        this.inputSlotA = new InvSlotRecipes(this, "macerator", this){

            @Override
            public boolean accepts(ItemStack itemStack, int index) {
                if (index == 4) {
                    int[] ids;
                    for (int i : ids = OreDictionary.getOreIDs((ItemStack)itemStack)) {
                        String name = OreDictionary.getOreName((int)i);
                        if (!name.startsWith("ore") && !name.startsWith("raw")) continue;
                        return false;
                    }
                    return super.accepts(itemStack, 0);
                }
                return false;
            }

            @Override
            public int getStackSizeLimit() {
                if (TileEntityMacerator.this.output == null) {
                    return 1;
                }
                return TileEntityMacerator.this.output.getRecipe().input.getInputs().get(0).getAmount();
            }
        };
        this.outputSlot = new InvSlotOutput(this, 1);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) && capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair1"));
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        ItemStack stack = drop.get(0);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74768_a("durability", this.durability);
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (nbt.func_74764_b("durability")) {
            this.durability = nbt.func_74762_e("durability");
        }
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockMacerator;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockMacerator.macerator;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.primal_macerator.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 64.0f, 1.0f);
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.MACERATOR);
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.put(0, ItemStack.field_190927_a);
        }
        if (name.equals("slot2")) {
            this.outputSlot.put(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onSneakingActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.durability >= 0 && this.durability < 96 && stack.func_77973_b() == IUItem.crafting_elements && stack.func_77952_i() == 41) {
            this.durability = 96;
            stack.func_190918_g(1);
            new PacketUpdateFieldTile(this, "durability", this.durability);
        }
        return super.onSneakingActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_145831_w().field_72995_K) {
            if (stack.func_190926_b() && this.output != null && this.outputSlot.isEmpty() && this.inputSlotA.continue_process(this.output) && this.durability > 0) {
                this.progress += (int)(4.0 + this.data.getOrDefault(player.func_110124_au(), 0.0) / 10.0);
                this.getCooldownTracker().setTick(10);
                this.setActive(!this.getActive());
                if (!this.func_145831_w().field_72995_K) {
                    this.initiate(0);
                }
                if (this.progress >= 100) {
                    this.progress = 0;
                    this.setActive(false);
                    if (!this.func_145831_w().field_72995_K) {
                        PrimitiveHandler.addExperience(EnumPrimitive.MACERATOR, 0.75, player.func_110124_au());
                    }
                    --this.durability;
                    this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                    this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                    this.output = null;
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                    }
                }
                return this.func_145831_w().field_72995_K;
            }
            if (!stack.func_190926_b()) {
                if (this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.accepts(stack, 4)) {
                    ItemStack stack1 = stack.func_77946_l();
                    stack1.func_190920_e(1);
                    this.inputSlotA.put(0, stack1);
                    stack.func_190918_g(1);
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
                if (!this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.get(0).func_77969_a(stack)) {
                    int minCount = this.inputSlotA.getStackSizeLimit() - this.inputSlotA.get(0).func_190916_E();
                    minCount = Math.min(stack.func_190916_E(), minCount);
                    this.inputSlotA.get(0).func_190917_f(minCount);
                    stack.func_190917_f(-minCount);
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
            } else {
                if (!this.outputSlot.isEmpty()) {
                    if (!this.field_145850_b.field_72995_K) {
                        ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
                    }
                    this.outputSlot.put(0, ItemStack.field_190927_a);
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot2", false);
                    }
                    return true;
                }
                if (!this.inputSlotA.isEmpty()) {
                    if (!this.field_145850_b.field_72995_K) {
                        ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.inputSlotA.get(), player);
                    }
                    this.inputSlotA.put(0, ItemStack.field_190927_a);
                    this.output = null;
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot3", false);
                    }
                    return true;
                }
            }
        }
        return this.field_145850_b.field_72995_K;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

