/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerPalletGenerator;
import com.denfop.gui.GuiPalletGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileElectricMachine;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPalletGenerator
extends TileElectricMachine {
    public static Map<ItemStack, Double> integerMap = new HashMap<ItemStack, Double>();
    public final InvSlot slot;
    public final ComponentBaseEnergy rad;
    public boolean update = true;
    public double generate = 0.0;

    public TileEntityPalletGenerator() {
        super(0.0, 14, 0);
        this.energy = this.addComponent(Energy.asBasicSource(this, 5000000.0, this.tier));
        this.rad = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.RADIATION, this, 1000000.0));
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 6){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                for (Map.Entry<ItemStack, Double> entry : integerMap.entrySet()) {
                    if (!entry.getKey().func_77969_a(stack)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                TileEntityPalletGenerator tile = (TileEntityPalletGenerator)this.base;
                tile.update = true;
            }
        };
        this.slot.setStackSizeLimit(1);
    }

    public static void init() {
        integerMap.put(new ItemStack((Item)IUItem.nuclear_res, 1, 8), 1.1);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 8), 1.2);
        integerMap.put(new ItemStack((Item)IUItem.nuclear_res, 1, 9), 1.3);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 4), 1.6);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 0), 1.75);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 1), 1.9);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 9), 2.05);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 2), 2.2);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 3), 2.45);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 6), 2.7);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 7), 2.85);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 10), 3.162);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 5), 3.32);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 11), 3.7);
        integerMap.put(new ItemStack((Item)IUItem.pellets, 1, 12), 4.0);
    }

    public ContainerPalletGenerator getGuiContainer(EntityPlayer var1) {
        return new ContainerPalletGenerator(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiPalletGenerator(this.getGuiContainer(var1));
    }

    @Override
    public void updateEntityServer() {
        double num;
        super.updateEntityServer();
        if (this.update) {
            this.update = false;
            num = 0.0;
            this.generate = 0.0;
            for (ItemStack stack : this.slot.getContents()) {
                for (Map.Entry<ItemStack, Double> entry : integerMap.entrySet()) {
                    if (!entry.getKey().func_77969_a(stack)) continue;
                    if (num == 0.0) {
                        num = entry.getValue();
                        continue;
                    }
                    num *= entry.getValue().doubleValue();
                }
            }
            if (num != 0.0) {
                this.generate = 20000.0 / Math.ceil(num);
            }
        }
        if (this.generate != 0.0) {
            num = this.energy.getFreeEnergy() / 50.0;
            if (num >= 1.0) {
                double num1 = this.rad.getEnergy() / this.generate;
                if (num1 >= 1.0) {
                    double num2 = Math.min(Math.min(num, num1), 10.0);
                    this.rad.useEnergy(num2 * this.generate);
                    this.energy.addEnergy(num2 * 50.0);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.pallet_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }
}

