/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerPlantGardener;
import com.denfop.gui.GuiPlantGardener;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.crop.TileEntityCrop;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPlantGardener
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 8;
    public final Energy energy;
    public final InvSlot output;
    public final InvSlotUpgrade upgradeSlot;
    private final ComponentUpgradeSlots componentUpgrade;
    AxisAlignedBB searchArea;
    List<List<TileEntityCrop>> list;
    List<Chunk> chunks;

    public TileEntityPlantGardener() {
        this.searchArea = new AxisAlignedBB(this.field_174879_c.func_177982_a(-8, -8, -8), this.field_174879_c.func_177982_a(8, 8, 8));
        this.list = new ArrayList<List<TileEntityCrop>>();
        this.output = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 9){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ICropItem;
            }
        };
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.plant_gardener;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.plant_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            AxisAlignedBB aabb;
            this.searchArea = aabb = this.searchArea.func_186670_a(this.field_174879_c);
            int j2 = MathHelper.func_76128_c((double)((aabb.field_72340_a - 2.0) / 16.0));
            int k2 = MathHelper.func_76143_f((double)((aabb.field_72336_d + 2.0) / 16.0));
            int l2 = MathHelper.func_76128_c((double)((aabb.field_72339_c - 2.0) / 16.0));
            int i3 = MathHelper.func_76143_f((double)((aabb.field_72334_f + 2.0) / 16.0));
            this.chunks = new ArrayList<Chunk>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    Chunk chunk = this.field_145850_b.func_72964_e(j3, k3);
                    if (this.chunks.contains(chunk)) continue;
                    this.chunks.add(chunk);
                }
            }
            for (Chunk chunk : this.chunks) {
                this.list.add(CropNetwork.instance.getCropsFromChunk(this.field_145850_b, chunk.func_76632_l()));
            }
        }
    }

    public ContainerPlantGardener getGuiContainer(EntityPlayer var1) {
        return new ContainerPlantGardener(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiPlantGardener(this.getGuiContainer(var1));
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.func_177958_n() > this.searchArea.field_72340_a && (double)vec.func_177958_n() < this.searchArea.field_72336_d) {
            if ((double)vec.func_177956_o() > this.searchArea.field_72338_b && (double)vec.func_177956_o() < this.searchArea.field_72337_e) {
                return (double)vec.func_177952_p() > this.searchArea.field_72339_c && (double)vec.func_177952_p() < this.searchArea.field_72334_f;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().func_72820_D() % 100L == 0L) {
            this.updateCrop();
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && this.energy.canUseEnergy(10.0)) {
            block0: for (List<TileEntityCrop> crops : this.list) {
                for (TileEntityCrop crop : crops) {
                    if (!(this.energy.getEnergy() > 10.0)) break block0;
                    if (!this.contains(crop.func_174877_v())) continue;
                    for (ItemStack stack : this.output) {
                        if (stack.func_190926_b() || crop.getCrop() != null || crop.isHasDouble() || !CropNetwork.instance.canPlantCrop(stack, this.field_145850_b, this.field_174879_c, crop.getDownState(), crop.getBiome())) continue;
                        crop.plantNewCrop(stack);
                        this.energy.useEnergy(10.0);
                    }
                }
            }
        }
    }

    private void updateCrop() {
        this.list.clear();
        for (Chunk chunk : this.chunks) {
            this.list.add(CropNetwork.instance.getCropsFromChunk(this.field_145850_b, chunk.func_76632_l()));
        }
    }
}

