/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockElectronicsAssembler;
import com.denfop.componets.ComponentProgress;
import com.denfop.container.ContainerElectronicsAssembler;
import com.denfop.gui.GuiElectronicsAssemble;
import com.denfop.items.resource.ItemIngots;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityPrimalElectronicsAssembler
extends TileElectricMachine
implements IUpdateTick,
IHasRecipe,
IUpdatableTileEvent {
    private static final int RED = 0;
    private static final int GRAY = 1;
    private static final int GREEN = 2;
    private static final int YELLOW = 3;
    private static final int SIZE = 146;
    private static Random random = new Random();
    public final ComponentProgress componentProgress;
    private final int MIN_DISTANCE = 5;
    private final int MAX_ATTEMPTS = 100;
    public InvSlotRecipes inputSlotA;
    public MachineRecipe output = null;
    public boolean start;
    public int[] data;
    public Map<UUID, Double> data1 = PrimitiveHandler.getPlayersData(EnumPrimitive.ELECTRONIC);
    private int RED_PERCENT = 35;
    private int GREEN_PERCENT = 80;
    private int YELLOW_PERCENT = 100 - this.RED_PERCENT - this.GREEN_PERCENT;

    public TileEntityPrimalElectronicsAssembler() {
        super(0.0, 0, 1);
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 300));
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "electronics", (IUpdateTick)this);
        Recipes.recipes.addInitRecipes(this);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static void add(ItemStack second, ItemStack three, ItemStack four, ItemStack five, ItemStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("temperature", (short)4000);
        IInputHandler input = Recipes.inputFactory;
        IInputItemStack first1 = input.getInput("ingotAluminum");
        IInputItemStack second1 = OreDictionary.getOreIDs((ItemStack)second).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0]).isEmpty() && second.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0])) : input.getInput(second);
        IInputItemStack three1 = OreDictionary.getOreIDs((ItemStack)three).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0]).isEmpty() && three.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0])) : input.getInput(three);
        IInputItemStack four1 = OreDictionary.getOreIDs((ItemStack)four).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0]).isEmpty() && four.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0])) : input.getInput(four);
        IInputItemStack five1 = OreDictionary.getOreIDs((ItemStack)five).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0]).isEmpty() && five.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0])) : input.getInput(five);
        Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(first1, second1, three1, four1, five1), new RecipeOutput(nbt, output)));
    }

    public static void add(ItemStack first, ItemStack second, ItemStack three, ItemStack four, ItemStack five, ItemStack output, short temperatures, boolean check) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("temperature", temperatures);
        IInputHandler input = Recipes.inputFactory;
        if (check) {
            IInputItemStack first1 = OreDictionary.getOreIDs((ItemStack)first).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)first)[0]).isEmpty() && first.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)first)[0]), first.func_190916_E()) : input.getInput(first);
            IInputItemStack second1 = OreDictionary.getOreIDs((ItemStack)second).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0]).isEmpty() && second.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0]), second.func_190916_E()) : input.getInput(second);
            IInputItemStack three1 = OreDictionary.getOreIDs((ItemStack)three).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0]).isEmpty() && three.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0]), three.func_190916_E()) : input.getInput(three);
            IInputItemStack four1 = OreDictionary.getOreIDs((ItemStack)four).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0]).isEmpty() && four.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0]), four.func_190916_E()) : input.getInput(four);
            IInputItemStack five1 = OreDictionary.getOreIDs((ItemStack)five).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0]).isEmpty() && five.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0]), five.func_190916_E()) : input.getInput(five);
            Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(first1, second1, three1, four1, five1), new RecipeOutput(nbt, output)));
        } else {
            Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(input.getInput(first), input.getInput(second), input.getInput(three), input.getInput(four), input.getInput(five)), new RecipeOutput(nbt, output)));
        }
    }

    public static void add(ItemStack first, ItemStack second, ItemStack three, ItemStack four, String five, ItemStack output, short temperatures, boolean check) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("temperature", temperatures);
        IInputHandler input = Recipes.inputFactory;
        if (check) {
            IInputItemStack first1 = OreDictionary.getOreIDs((ItemStack)first).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)first)[0]).isEmpty() && first.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)first)[0])) : input.getInput(first);
            IInputItemStack second1 = OreDictionary.getOreIDs((ItemStack)second).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0]).isEmpty() && second.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0])) : input.getInput(second);
            IInputItemStack three1 = OreDictionary.getOreIDs((ItemStack)three).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0]).isEmpty() && three.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0])) : input.getInput(three);
            IInputItemStack four1 = OreDictionary.getOreIDs((ItemStack)four).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0]).isEmpty() && four.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0])) : input.getInput(four);
            IInputItemStack five1 = input.getInput(five);
            Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(first1, second1, three1, four1, five1), new RecipeOutput(nbt, output)));
        }
    }

    public static void add(String first, ItemStack second, ItemStack three, ItemStack four, ItemStack five, ItemStack output, boolean check) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("temperature", (short)4500);
        IInputHandler input = Recipes.inputFactory;
        if (check) {
            IInputItemStack first1 = input.getInput(first);
            IInputItemStack second1 = OreDictionary.getOreIDs((ItemStack)second).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0]).isEmpty() && second.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0])) : input.getInput(second);
            IInputItemStack three1 = OreDictionary.getOreIDs((ItemStack)three).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0]).isEmpty() && three.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0])) : input.getInput(three);
            IInputItemStack four1 = OreDictionary.getOreIDs((ItemStack)four).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0]).isEmpty() && four.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)four)[0])) : input.getInput(four);
            IInputItemStack five1 = OreDictionary.getOreIDs((ItemStack)five).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0]).isEmpty() && five.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0])) : input.getInput(five);
            Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(first1, second1, three1, four1, five1), new RecipeOutput(nbt, output)));
        } else {
            Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(input.getInput(first), input.getInput(second), input.getInput(three), input.getInput(four), input.getInput(five)), new RecipeOutput(nbt, output)));
        }
    }

    public static void add(ItemStack first, ItemStack second, ItemStack three, String four, ItemStack five, ItemStack output, boolean check) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("temperature", (short)2000);
        IInputHandler input = Recipes.inputFactory;
        if (check) {
            IInputItemStack first1 = OreDictionary.getOreIDs((ItemStack)first).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)first)[0]).isEmpty() && first.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)first)[0])) : input.getInput(first);
            IInputItemStack second1 = OreDictionary.getOreIDs((ItemStack)second).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0]).isEmpty() && second.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)second)[0])) : input.getInput(second);
            IInputItemStack three1 = OreDictionary.getOreIDs((ItemStack)three).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0]).isEmpty() && three.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)three)[0])) : input.getInput(three);
            IInputItemStack four1 = input.getInput(four);
            IInputItemStack five1 = OreDictionary.getOreIDs((ItemStack)five).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0]).isEmpty() && five.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)five)[0])) : input.getInput(five);
            Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(first1, second1, three1, four1, five1), new RecipeOutput(nbt, output)));
        } else {
            Recipes.recipes.addRecipe("microchip", new BaseMachineRecipe(new Input(input.getInput(first), input.getInput(second), input.getInput(three), input.getInput(four), input.getInput(five)), new RecipeOutput(nbt, output)));
        }
    }

    private int[] generateColorStrip() {
        int[] data = new int[146];
        this.fillGrayZones(data);
        this.createGrayGaps(data);
        this.createIslandsWithSpacing(data, 0, this.RED_PERCENT);
        this.createIslandsWithSpacing(data, 2, this.GREEN_PERCENT);
        this.placeYellow(data);
        return data;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    private void fillGrayZones(int[] data) {
        for (int i = 0; i < 146; ++i) {
            data[i] = 1;
        }
    }

    private void createGrayGaps(int[] data) {
        int length;
        for (int index = 0; index < 146; index += length + 5) {
            length = random.nextInt(11) + 10;
            if (index + length > 146) {
                length = 146 - index;
            }
            for (int i = index; i < index + length; ++i) {
                data[i] = 1;
            }
        }
    }

    private void createIslandsWithSpacing(int[] data, int color, int percent) {
        int totalColorCount = 146 * percent / 100;
        int numIslands = random.nextInt(3) + 3;
        while (totalColorCount > 0 && numIslands > 0) {
            int attempts;
            int islandLength = random.nextInt(21) + 10;
            if (islandLength > totalColorCount) {
                islandLength = totalColorCount;
            }
            boolean placed = false;
            for (attempts = 0; !placed && attempts < 100; ++attempts) {
                int startIndex = random.nextInt(146 - islandLength);
                if (!this.isValidPlacement(data, startIndex, islandLength, color)) continue;
                for (int i = startIndex; i < startIndex + islandLength; ++i) {
                    data[i] = color;
                }
                totalColorCount -= islandLength;
                placed = true;
                --numIslands;
            }
            if (attempts < 100) continue;
            break;
        }
    }

    private boolean isValidPlacement(int[] data, int startIndex, int length, int color) {
        for (int i = startIndex; i < startIndex + length; ++i) {
            if (data[i] == 1) continue;
            return false;
        }
        if (startIndex > 0 && data[startIndex - 1] == color) {
            return false;
        }
        return startIndex + length >= 146 || data[startIndex + length] != color;
    }

    private void placeYellow(int[] data) {
        int yellowStart = random.nextInt(144);
        data[yellowStart] = 3;
        data[yellowStart + 1] = 3;
        if (yellowStart > 0) {
            data[yellowStart - 1] = 1;
        }
        if (yellowStart + 2 < 146) {
            data[yellowStart + 2] = 1;
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (this.start && var2 == 0.0) {
            this.componentProgress.addProgress(0, (short)(60.0 * (1.0 + this.data1.getOrDefault(var1.func_110124_au(), 0.0) / 66.0)));
            if (this.componentProgress.getProgress(0) >= 300) {
                this.componentProgress.setProgress((short)300);
                if (!this.func_145831_w().field_72995_K) {
                    PrimitiveHandler.addExperience(EnumPrimitive.ELECTRONIC, 0.75, var1.func_110124_au());
                }
            }
            this.GREEN_PERCENT = (int)(80.0 * (1.0 - 0.75 * this.componentProgress.getBar()));
            this.RED_PERCENT = (int)(35.0 * (1.0 + 0.5 * this.componentProgress.getBar()));
            this.data = this.generateColorStrip();
        } else if (this.start && var2 == 1.0) {
            this.componentProgress.addProgress(0, (short)-10);
            if (this.componentProgress.getProgress(0) < 0) {
                this.componentProgress.setProgress((short)0);
            }
            this.GREEN_PERCENT = (int)(80.0 * (1.0 - 0.75 * this.componentProgress.getBar()));
            this.RED_PERCENT = (int)(35.0 * (1.0 + 0.5 * this.componentProgress.getBar()));
            this.data = this.generateColorStrip();
        } else if (this.start && var2 == 2.0) {
            this.componentProgress.setProgress(0, (short)300);
            if (!this.func_145831_w().field_72995_K) {
                PrimitiveHandler.addExperience(EnumPrimitive.ELECTRONIC, 0.75, var1.func_110124_au());
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlotA.load();
        this.getOutput();
        this.data1 = PrimitiveHandler.getPlayersData(EnumPrimitive.ELECTRONIC);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiChargeLevel = (Double)DecoderHandler.decode(customPacketBuffer);
            this.start = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.data = (int[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiChargeLevel);
            EncoderHandler.encode(packet, this.start);
            EncoderHandler.encode(packet, this.data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.start) {
            if (this.output != null) {
                if (this.inputSlotA.continue_process(this.output) && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items)) {
                    this.start = true;
                    this.data = this.generateColorStrip();
                } else {
                    this.start = false;
                }
            }
        } else if (this.output == null) {
            this.start = false;
        }
        if (this.start && this.componentProgress.getBar() >= 1.0) {
            this.inputSlotA.consume();
            this.componentProgress.setProgress(0, (short)0);
            this.outputSlot.add(this.output.getRecipe().getOutput().items);
            this.getOutput();
        }
    }

    public ContainerElectronicsAssembler getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectronicsAssembler(entityPlayer, this);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockElectronicsAssembler.electronics_assembler;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.electronics_assembler;
    }

    @Override
    public void init() {
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public String getInventoryName() {
        return "Generation Microchip";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectronicsAssemble(new ContainerElectronicsAssembler(entityPlayer, this));
    }

    public String getStartSoundFile() {
        return "Machines/genmirc.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

