/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockPrimalFluidIntegrator;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerFluidIntegrator;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.render.tank.DataFluid;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPrimalFluidIntegrator
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotRecipes inputSlotA;
    public final Fluids.InternalFluidTank fluidTank1;
    public final Fluids.InternalFluidTank fluidTank2;
    public final FluidHandlerRecipe fluid_handler;
    public final int defaultOperationLength;
    private final Fluids fluids;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    @SideOnly(value=Side.CLIENT)
    public DataFluid dataFluid;
    @SideOnly(value=Side.CLIENT)
    public DataFluid dataFluid1;
    protected short progress;
    private int prevAmount;
    private int prevAmount1;

    public TileEntityPrimalFluidIntegrator() {
        super(0.0, 0, 1);
        Recipes.recipes.addInitRecipes(this);
        this.progress = 0;
        this.operationLength = 200;
        this.defaultOperationLength = 200;
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = this.fluids.addTankInsert("fluidTank1", 1000);
        this.fluidTank2 = this.fluids.addTank("fluidTank2", 1000, InvSlot.TypeItemSlot.OUTPUT);
        this.inputSlotA = new InvSlotRecipes(this, "primal_fluid_integrator", this, this.fluidTank1){

            @Override
            public boolean accepts(ItemStack itemStack, int index) {
                if (index == 4) {
                    return super.accepts(itemStack, 0);
                }
                return false;
            }
        };
        this.inputSlotA.setStackSizeLimit(1);
        this.fluid_handler = new FluidHandlerRecipe("primal_fluid_integrator", this.fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        this.fluidTank2.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
    }

    public static void addRecipe(ItemStack container, ItemStack output, FluidStack fluidStack, FluidStack outputfluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("primal_fluid_integrator", new BaseMachineRecipe(new Input(fluidStack, input.getInput(container)), new RecipeOutput(null, output)));
        Recipes.recipes.getRecipeFluid().addRecipe("primal_fluid_integrator", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container, fluidStack), Collections.singletonList(outputfluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 6; ++i) {
            tooltip.add(Localization.translate("fluid_integrator.info" + i));
        }
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AxisAlignedBB(-0.2, 0.0, -0.2, 1.2, 1.0, 1.2));
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    public ContainerFluidIntegrator getGuiContainer(EntityPlayer var1) {
        return null;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            FluidTank fluidTank2;
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
            }
            if ((fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer)) != null) {
                this.fluidTank2.readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
            }
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("guiProgress")) {
            try {
                this.guiProgress = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank1")) {
            try {
                FluidTank fluidTank2 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank2 != null) {
                    this.fluidTank2.readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank_empty")) {
            this.fluidTank1.drain(Integer.MAX_VALUE, true);
        }
        if (name.equals("fluidtank1_empty")) {
            this.fluidTank2.drain(Integer.MAX_VALUE, true);
        }
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.put(0, ItemStack.field_190927_a);
        }
        if (name.equals("slot2")) {
            this.outputSlot.put(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.accepts(stack, 4)) {
                ItemStack stack1 = stack.func_77946_l();
                stack1.func_190920_e(1);
                this.inputSlotA.put(0, stack1);
                stack.func_190918_g(1);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
                }
                this.outputSlot.put(0, ItemStack.field_190927_a);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.inputSlotA.get(), player);
                }
                this.inputSlotA.put(0, ItemStack.field_190927_a);
                this.output = null;
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank2);
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return null;
    }

    @Override
    public void init() {
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack(IUItem.iuingot, 1, 15), new ItemStack((Item)IUItem.iudust, 1, 42), new FluidStack(FluidName.fluiddibromopropane.getInstance(), 200), new FluidStack(FluidName.fluidpropylene.getInstance(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((Item)IUItem.crafting_elements, 1, 482), new ItemStack((Item)IUItem.iudust, 1, 43), new FluidStack(FluidRegistry.WATER, 200), new FluidStack(FluidName.fluidacetylene.getInstance(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack(IUItem.iuingot, 1, 21), new ItemStack((Item)IUItem.smalldust, 3, 20), new FluidStack(FluidName.fluidsulfuricacid.getInstance(), 200), new FluidStack(FluidName.fluidcoppersulfate.getInstance(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((Item)IUItem.crafting_elements, 1, 489), new ItemStack((Item)IUItem.crafting_elements, 1, 487), new FluidStack(FluidName.fluidcoppersulfate.getInstance(), 500), new FluidStack(FluidName.fluidwastesulfuricacid.getInstance(), 500));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((Block)IUItem.heavyore, 1, 4), new ItemStack((Item)IUItem.smalldust, 1, 22), new FluidStack(FluidRegistry.WATER, 1000), new FluidStack(FluidName.fluidsulfuroxide.getInstance(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((Item)IUItem.crafting_elements, 1, 492), new ItemStack((Item)IUItem.crafting_elements, 1, 493), new FluidStack(FluidRegistry.WATER, 500), new FluidStack(FluidName.fluidhyd.getInstance(), 50));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((Item)IUItem.iudust, 1, 21), new ItemStack((Item)IUItem.crafting_elements, 1, 498), new FluidStack(FluidName.fluidhyd.getInstance(), 200), new FluidStack(FluidRegistry.WATER, 100));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack(Blocks.field_150346_d), new ItemStack((Block)Blocks.field_150391_bh), new FluidStack(FluidName.fluidhoney.getInstance(), 1000), new FluidStack(FluidName.fluidoxy.getInstance(), 75));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.fluidIntegrator;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPrimalFluidIntegrator.primal_fluid_integrator;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get());
            this.getOutput();
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && this.output != null && this.fluidTank1.getFluidAmount() > 0) {
            this.fluid_handler.getOutput(this.inputSlotA.get());
        } else if (this.fluid_handler.output() != null && this.output == null) {
            this.fluid_handler.setOutput(null);
        }
        if (this.prevAmount != this.fluidTank1.getFluidAmount()) {
            this.prevAmount = this.fluidTank1.getFluidAmount();
            if (this.prevAmount != 0) {
                new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
            } else {
                new PacketUpdateFieldTile(this, "fluidtank_empty", true);
            }
        }
        if (this.prevAmount1 != this.fluidTank2.getFluidAmount()) {
            this.prevAmount1 = this.fluidTank2.getFluidAmount();
            if (this.prevAmount1 != 0) {
                new PacketUpdateFieldTile(this, "fluidtank1", (Object)this.fluidTank2);
            } else {
                new PacketUpdateFieldTile(this, "fluidtank1_empty", true);
            }
        }
        if (this.output != null && !this.inputSlotA.isEmpty() && this.outputSlot.isEmpty() && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items) && this.inputSlotA.continue_process(this.output) && this.fluid_handler.output() != null && this.fluid_handler.canOperate() && this.fluid_handler.canFillFluid()) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
                new PacketUpdateFieldTile(this, "guiProgress", this.guiProgress);
            }
            if (this.field_145850_b.func_72820_D() % 20L == 0L) {
                new PacketUpdateFieldTile(this, "guiProgress", this.guiProgress);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.outputSlot.add(this.output.getRecipe().getOutput().items);
        this.fluid_handler.fillFluid();
        new PacketUpdateFieldTile(this, "slot3", false);
        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

