/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalLaserPolisher;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityPrimalLaserPolisher
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "primal_laser_polisher", (IUpdateTick)this);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public int progress = 0;
    public MachineRecipe output;
    public int tick = 0;
    public Map<UUID, Double> data;

    public TileEntityPrimalLaserPolisher() {
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair3"));
        tooltip.add(Localization.translate("iu.primal_repair6"));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.primalPolisher;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPrimalLaserPolisher.primal_laser_polisher;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) && capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.LASER);
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.put(0, ItemStack.field_190927_a);
        }
        if (name.equals("slot2")) {
            this.outputSlot.put(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.setActive(!this.inputSlotA.isEmpty());
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == IUItem.laser && this.output != null && this.outputSlot.isEmpty() && this.func_145831_w().func_72935_r()) {
            this.progress += (short)(5 + (short)(this.data.getOrDefault(player.func_110124_au(), 0.0) / 10.0));
            this.getCooldownTracker().setTick(10);
            if (this.progress >= 100) {
                this.progress = 0;
                player.func_184611_a(hand, stack.func_77973_b().getContainerItem(stack));
                if (!this.func_145831_w().field_72995_K) {
                    PrimitiveHandler.addExperience(EnumPrimitive.LASER, 0.5, player.func_110124_au());
                }
                this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (this.inputSlotA.isEmpty() || this.outputSlot.get().func_190916_E() >= 64) {
                    this.output = null;
                }
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                }
            }
            return true;
        }
        if (!stack.func_190926_b()) {
            if (this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.accepts(stack, 0)) {
                ItemStack stack1 = stack.func_77946_l();
                stack1.func_190920_e(1);
                this.inputSlotA.put(0, stack1);
                this.output = this.inputSlotA.process();
                stack.func_190918_g(1);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
            if (!this.outputSlot.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
                }
                this.outputSlot.put(0, ItemStack.field_190927_a);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
                }
                this.outputSlot.put(0, ItemStack.field_190927_a);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.inputSlotA.get(), player);
                }
                this.inputSlotA.put(0, ItemStack.field_190927_a);
                this.output = null;
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.crafting_elements, 1, 493))), new RecipeOutput(null, new ItemStack((Item)IUItem.crafting_elements, 1, 495))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 0))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 0))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 1))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 1))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 2))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 2))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 3))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 3))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 4))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 6))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 5))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 7))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 6))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 8))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 7))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 9))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 8))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 10))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 9))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 11))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 10))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 12))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 10))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 12))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 11))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 14))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 12))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 15))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 13))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 16))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 14))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 17))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 15))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 18))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 16))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 21))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 17))), new RecipeOutput(null, new ItemStack(Items.field_151043_k, 1))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 18))), new RecipeOutput(null, new ItemStack(Items.field_151042_j, 1))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 19))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 22))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 20))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 24))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 22))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 25))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 23))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 26))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, 24))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, 27))));
        for (int i = 25; i < 40; ++i) {
            Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.rawIngot, 1, i))), new RecipeOutput(null, new ItemStack(IUItem.iuingot, 1, i + 3))));
        }
    }
}

