/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalPump;
import com.denfop.componets.ComponentProgress;
import com.denfop.container.ContainerPump;
import com.denfop.gui.GuiPump;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPrimalPump
extends TileElectricLiquidTankInventory {
    public ComponentProgress componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 25));
    private int prevAmount;

    public TileEntityPrimalPump() {
        super(0.0, 1, 4);
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPrimalPump.primal_pump;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.primal_pump;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean onSneakingActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && this.fluidTank.getFluidAmount() + 1000 <= this.fluidTank.getCapacity()) {
            if (this.componentProgress.getProgress() < this.componentProgress.getMaxValue()) {
                this.componentProgress.addProgress(0, (short)4);
            } else if (this.canoperate()) {
                this.componentProgress.setProgress((short)0);
            }
            this.setActive(true);
        } else {
            this.setActive(false);
        }
        return super.onSneakingActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 6; ++i) {
            tooltip.add(Localization.translate("primitive_pump.info" + i));
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.prevAmount != this.fluidTank.getFluidAmount()) {
            this.prevAmount = this.fluidTank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank);
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        for (int i = this.field_174879_c.func_177958_n() - 1; i <= this.field_174879_c.func_177958_n() + 1; ++i) {
            for (int j = this.field_174879_c.func_177952_p() - 1; j <= this.field_174879_c.func_177952_p() + 1; ++j) {
                for (int k = this.field_174879_c.func_177956_o() - 1; k <= this.field_174879_c.func_177956_o() - 1; ++k) {
                    if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
                        return false;
                    }
                    FluidStack liquid = this.pump(new BlockPos(i, k, j), false);
                    if (this.getFluidTank().fill(liquid, false) <= 0) continue;
                    this.getFluidTank().fill(liquid, true);
                    canOperate = true;
                }
            }
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        IBlockState block;
        FluidStack ret = null;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.func_145831_w().func_180495_p(pos)).func_185904_a().func_76224_d()) {
            if (block.func_177230_c() instanceof IFluidBlock) {
                IFluidBlock liquid = (IFluidBlock)block.func_177230_c();
                if ((this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == liquid.getFluid()) && liquid.canDrain(this.func_145831_w(), pos)) {
                    if (!sim) {
                        ret = liquid.drain(this.func_145831_w(), pos, true);
                        this.func_145831_w().func_175698_g(pos);
                    } else {
                        ret = new FluidStack(liquid.getFluid(), 1000);
                    }
                }
            } else {
                if (block.func_177230_c().func_176201_c(block) != 0) {
                    return null;
                }
                ret = new FluidStack(FluidRegistry.getFluid((String)block.func_177230_c().func_149739_a().substring(5)), 1000);
                if (!(this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != ret.getFluid() || sim)) {
                    this.func_145831_w().func_175698_g(pos);
                }
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    public ContainerPump getGuiContainer(EntityPlayer entityPlayer) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiPump getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return null;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

