/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalSiliconCrystalHandler;
import com.denfop.componets.ComponentTimer;
import com.denfop.container.ContainerSiliconCrystalHandler;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityPrimalSiliconCrystalHandler
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final ComponentTimer timer;
    public final InvSlotRecipes inputSlotA;
    public final InvSlotUpgrade upgradeSlot;
    public int col;
    private MachineRecipe output;
    private int level;
    private boolean checkState;

    public TileEntityPrimalSiliconCrystalHandler() {
        super(0.0, 0, 1);
        Recipes.recipes.addInitRecipes(this);
        this.inputSlotA = new InvSlotRecipes(this, "silicon_recipe", this){

            @Override
            public boolean accepts(ItemStack itemStack, int index) {
                return false;
            }
        };
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.timer = this.addComponent(new ComponentTimer(this, new Timer(0, 12, 30)));
        this.level = 0;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair4"));
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("timer")) {
            try {
                is.readByte();
                this.timer.onNetworkUpdate(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.inputSlotA.load();
            this.getOutput();
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.outputSlot.isEmpty()) {
            if (stack.func_77973_b() == IUItem.iudust && stack.func_77952_i() == 60) {
                if (this.inputSlotA.get(1).func_190926_b()) {
                    ItemStack stack1 = stack.func_77946_l();
                    if (stack1.func_190916_E() > 3) {
                        stack1.func_190920_e(3);
                        stack.func_190918_g(3);
                    } else {
                        stack.func_190918_g(stack1.func_190916_E());
                    }
                    this.inputSlotA.put(1, stack1);
                    if (!this.field_145850_b.field_72995_K) {
                        this.getOutput();
                    }
                    return true;
                }
                if (!this.inputSlotA.get(1).func_190926_b() && this.inputSlotA.get(1).func_77969_a(stack)) {
                    int minCount = 3 - this.inputSlotA.get(1).func_190916_E();
                    minCount = Math.min(stack.func_190916_E(), minCount);
                    this.inputSlotA.get(1).func_190917_f(minCount);
                    stack.func_190917_f(-minCount);
                    if (!this.field_145850_b.field_72995_K) {
                        this.getOutput();
                    }
                    return true;
                }
            } else if (stack.func_77973_b() == Items.field_151145_ak && !this.inputSlotA.get(1).func_190926_b() && this.inputSlotA.get(1).func_190916_E() >= 3 && this.inputSlotA.get(0).func_190926_b()) {
                ItemStack stack1 = stack.func_77946_l();
                if (stack1.func_190916_E() > 1) {
                    stack1.func_190920_e(1);
                    stack.func_190918_g(1);
                } else {
                    stack.func_190918_g(stack1.func_190916_E());
                }
                this.inputSlotA.put(0, stack1);
                if (!this.field_145850_b.field_72995_K) {
                    this.getOutput();
                }
                return true;
            }
        } else if (!this.outputSlot.isEmpty()) {
            if (!this.field_145850_b.field_72995_K) {
                ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
            }
            this.outputSlot.put(0, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.timer, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.primalSiliconCrystal;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPrimalSiliconCrystalHandler.primal_silicon_crystal_handler;
    }

    @Override
    public void onUpdate() {
    }

    public ContainerSiliconCrystalHandler getGuiContainer(EntityPlayer var1) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return null;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L) {
            new PacketUpdateFieldTile(this, "timer", this.timer);
            this.checkState = false;
            ItemStack stack1 = this.inputSlotA.get(0);
            ItemStack stack2 = this.inputSlotA.get(1);
            if (this.outputSlot.isEmpty()) {
                if (stack1.func_190926_b()) {
                    if (!stack2.func_190926_b()) {
                        switch (stack2.func_190916_E()) {
                            case 1: {
                                this.setActive("1");
                                break;
                            }
                            case 2: {
                                this.setActive("2");
                                break;
                            }
                            default: {
                                this.setActive("3");
                                break;
                            }
                        }
                    } else {
                        this.setActive(false);
                    }
                } else if (this.outputSlot.isEmpty()) {
                    if (stack2.func_190916_E() >= 3) {
                        double time = this.timer.getTimes();
                        if (time >= 0.5 && time < 1.0) {
                            this.setActive("5");
                        } else if (time < 0.5) {
                            this.setActive("4");
                        } else {
                            this.setActive("6");
                        }
                    } else {
                        this.setActive(false);
                    }
                } else {
                    this.setActive("6");
                }
            } else {
                this.setActive("6");
            }
        }
        if (this.inputSlotA.get().func_190926_b() || this.output == null || !this.outputSlot.get().func_190926_b()) {
            this.timer.setCanWorkWithOut(false);
            return;
        }
        if (!this.timer.isCanWork()) {
            this.timer.setCanWork(true);
        }
        if (this.timer.getTimers().get(0).getTime() <= 0) {
            this.inputSlotA.consume();
            this.outputSlot.add(this.output.getRecipe().output.items.get(0));
            this.output = null;
            this.timer.resetTime();
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(this.tier + this.upgradeSlot.extraTier);
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        if (this.output != null) {
            this.timer.resetTime();
        }
        return this.output;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("level", this.level);
        return nbttagcompound;
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        return ret;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) && capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.timer.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

