/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityInventory;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPurifierSoil
extends TileEntityInventory
implements IManufacturerBlock {
    public final Energy energy = this.addComponent(Energy.asBasicSink(this, 10000.0));
    public ChunkLevel chunkLevel = null;
    public ChunkPos chunkPos;
    public int level;

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return true;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 0) {
            ret.add(new ItemStack((Item)IUItem.upgrade_speed_creation, this.level));
            this.level = 0;
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.level = nbttagcompound.func_74762_e("level");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("level", this.level);
        return nbttagcompound;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.chunkPos = new ChunkPos(this.field_174879_c);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.chunkLevel != null);
        if (this.chunkLevel != null) {
            customPacketBuffer.writeBytes((ByteBuf)this.chunkLevel.writePacket());
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        boolean exist = customPacketBuffer.readBoolean();
        if (exist) {
            this.chunkLevel = new ChunkLevel(customPacketBuffer);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L && this.energy.getEnergy() > 100.0) {
            this.chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
            if (this.chunkLevel != null) {
                ChunkLevel chunkLevel1 = PollutionManager.pollutionManager.getChunkLevelAir(this.chunkPos);
                if (this.chunkLevel.removePollution(10 + this.level * 50)) {
                    chunkLevel1.addPollution(25 + this.level * 25);
                    this.energy.useEnergy(100.0);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.purifier_soil;
    }
}

