/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerRadioactiveOreHandler;
import com.denfop.gui.GuiRadioactiveOreHandler;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityRadioactiveOreHandler
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    public final InvSlotRecipes inputSlotA;
    public final ComponentBaseEnergy componentRadiation;
    public final InvSlotOutput outputSlot1;
    public MachineRecipe output;

    public TileEntityRadioactiveOreHandler() {
        super(200.0, 1, 1);
        Recipes.recipes.addInitRecipes(this);
        this.outputSlot1 = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((TileEntityRadioactiveOreHandler)this.getParent()).componentProcess;
                this.energy = this.getParent().getComp(Energy.class);
                this.setOverclockRates(this.invSlot);
            }
        });
        this.addComponent(new SoilPollutionComponent(this, 0.25));
        this.addComponent(new AirPollutionComponent(this, 0.25));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 100));
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "radioactive_handler", (IUpdateTick)this);
        this.componentProcess = this.addComponent(new ComponentProcess(this, 200, 1.0){

            @Override
            public boolean checkRecipe() {
                return TileEntityRadioactiveOreHandler.this.componentRadiation.getEnergy() + 1.0 < TileEntityRadioactiveOreHandler.this.componentRadiation.getCapacity();
            }

            @Override
            protected int getRadiationSize(int size) {
                return (int)Math.min((double)size, TileEntityRadioactiveOreHandler.this.componentRadiation.getCapacity() - TileEntityRadioactiveOreHandler.this.componentRadiation.getEnergy());
            }

            @Override
            public boolean canAddItemStack() {
                return this.outputSlot.canAdd(this.updateTick.getRecipeOutput().getRecipe().getOutput().items.get(0));
            }

            @Override
            public void operateWithMax(MachineRecipe output) {
                if (output.getRecipe() == null) {
                    return;
                }
                int size = 64;
                List<Integer> list = this.updateTick.getRecipeOutput().getList();
                if (this.invSlotRecipes.getRecipe().workbench()) {
                    size = 1;
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        size = Math.min(size, this.invSlotRecipes.get(i).func_190916_E() / list.get(i));
                    }
                }
                int maxSize = size;
                int count = this.outputSlot.get().func_190926_b() ? output.getRecipe().output.items.get(0).func_77976_d() : this.outputSlot.get().func_77976_d() - this.outputSlot.get().func_190916_E();
                ItemStack outputStack = this.updateTick.getRecipeOutput().getRecipe().output.items.get(0);
                size = Math.min(size, count /= Math.max(outputStack.func_190916_E(), 1));
                size = Math.min(size, this.updateTick.getRecipeOutput().getRecipe().output.items.get(0).func_77973_b().func_77639_j());
                if (this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null) {
                    int size1 = this.invSlotRecipes.getTank().getFluidAmount() / this.updateTick.getRecipeOutput().getRecipe().input.getFluid().amount;
                    size = Math.min(size, size1);
                }
                size = Math.min(size, this.operationsPerTick);
                size = Math.min(this.getSESize(size), this.getRadiationSize(size));
                this.invSlotRecipes.consume(size, output);
                this.outputSlot.add(output.getRecipe().getOutput().items.get(0), size);
                for (int i = 0; i < size; ++i) {
                    if (WorldBaseGen.random.nextInt(100) >= output.getRecipe().output.metadata.func_74762_e("random")) continue;
                    TileEntityRadioactiveOreHandler.this.outputSlot1.add(output.getRecipe().getOutput().items.get(1));
                }
                this.consumeSE(size);
                this.consumeRadiation(size);
                if (maxSize == size) {
                    this.updateTick.setRecipeOutput(null);
                }
            }

            @Override
            protected void consumeRadiation(int size) {
                TileEntityRadioactiveOreHandler.this.componentRadiation.addEnergy(size);
            }

            @Override
            public boolean checkRadiation(boolean consume) {
                return true;
            }
        });
        this.componentRadiation = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.RADIATION, this, 2000.0));
        this.componentProcess.setHasAudio(false);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static void addRecipe(ItemStack container, ItemStack output, int random, ItemStack itemStack) {
        IInputHandler input = Recipes.inputFactory;
        NBTTagCompound nbt = ModUtils.nbt();
        nbt.func_74768_a("random", random);
        Recipes.recipes.addRecipe("radioactive_handler", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(nbt, output, itemStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerRadioactiveOreHandler getGuiContainer(EntityPlayer var1) {
        return new ContainerRadioactiveOreHandler(var1, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiRadioactiveOreHandler(this.getGuiContainer(var1));
    }

    @Override
    public void init() {
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((Block)IUItem.classic_ore, 1, 3), new ItemStack((Item)IUItem.nuclear_res, 2, 21), 5, new ItemStack((Item)IUItem.nuclear_res, 1, 16));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((Block)IUItem.toriyore, 1), new ItemStack((Item)IUItem.nuclear_res, 1, 19), 10, new ItemStack((Item)IUItem.nuclear_res, 4, 14));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((Block)IUItem.radiationore, 1, 1), new ItemStack((Item)IUItem.nuclear_res, 1, 18), 10, new ItemStack((Item)IUItem.nuclear_res, 4, 13));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((Block)IUItem.radiationore, 1), new ItemStack((Item)IUItem.nuclear_res, 1, 17), 10, new ItemStack((Item)IUItem.nuclear_res, 4, 15));
        TileEntityRadioactiveOreHandler.addRecipe(new ItemStack((Block)IUItem.radiationore, 1, 2), new ItemStack((Item)IUItem.nuclear_res, 1, 20), 20, new ItemStack((Item)IUItem.nuclear_res, 4, 15));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.radioactive_handler_ore;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

