/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.InfoSends;
import com.denfop.api.space.colonies.Sends;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.api.space.research.event.ResearchTableLoadEvent;
import com.denfop.api.space.research.event.ResearchTableReLoadEvent;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerResearchTableSpace;
import com.denfop.gui.GuiResearchTableSpace;
import com.denfop.invslot.InvSlot;
import com.denfop.items.space.ItemResearchLens;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFakeBody;
import com.denfop.tiles.base.TileEntityInventory;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityResearchTableSpace
extends TileEntityInventory
implements IResearchTable {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 2.0, 2.0, 1.5));
    private static final List<AxisAlignedBB> aabbs_east = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 2.0, 1.0));
    private static final List<AxisAlignedBB> aabbs_south = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 2.0, 2.0, 1.0));
    private static final List<AxisAlignedBB> aabbs_west = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 2.0));
    private static final List<AxisAlignedBB> aabbs_north = Collections.singletonList(new AxisAlignedBB(-1.0, 0.0, 0.0, 1.0, 2.0, 1.0));
    public final InvSlot slotLens;
    public Map<IBody, SpaceOperation> map;
    public List<SpaceOperation> fakeBodySpaceOperationMap;
    public EnumLevels level = EnumLevels.NONE;
    public int timer;
    public Map<IBody, Data> dataMap = new HashMap<IBody, Data>();
    public Map<IBody, SpaceOperation> operationMap;
    public IBody body;
    public IFakeBody fakeBody;
    public IColony colony;
    boolean added = false;
    private UUID player = null;
    private InfoSends sends;

    public TileEntityResearchTableSpace() {
        this.map = new HashMap<IBody, SpaceOperation>();
        this.fakeBodySpaceOperationMap = new LinkedList<SpaceOperation>();
        this.slotLens = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ItemResearchLens;
            }

            @Override
            public void update() {
                super.update();
                TileEntityResearchTableSpace.this.level = this.get().func_190926_b() ? EnumLevels.NONE : EnumLevels.values()[this.get().func_77952_i()];
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                this.update();
            }
        };
    }

    public InfoSends getSends() {
        return this.sends;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.research_table_space;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new ResearchTableLoadEvent(this.func_145831_w(), this));
            this.added = true;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.getSpaceBody();
            this.dataMap.clear();
            this.dataMap = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(this.player);
            for (IBody body : SpaceNet.instance.getBodyMap().values()) {
                if (this.dataMap.containsKey(body)) continue;
                this.dataMap.put(body, new Data(this.player, body));
            }
        }
        this.slotLens.update();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new ResearchTableLoadEvent(this.func_145831_w(), this));
            this.added = false;
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.dataMap.clear();
        try {
            NBTTagCompound nbt = (NBTTagCompound)DecoderHandler.decode(customPacketBuffer);
            NBTTagList tagList = nbt.func_150295_c("list", 10);
            for (NBTBase nbtbase : tagList.field_74747_a) {
                NBTTagCompound tagCompound = (NBTTagCompound)nbtbase;
                Data data = new Data(tagCompound);
                this.dataMap.put(data.getBody(), data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean hasColony = customPacketBuffer.readBoolean();
        if (hasColony) {
            this.colony = new Colony(customPacketBuffer);
            this.sends = new InfoSends(customPacketBuffer);
        } else {
            this.colony = null;
            this.sends = null;
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<IBody, Data> entry : this.dataMap.entrySet()) {
            NBTTagCompound nbt = entry.getValue().writeNBT();
            tagList.func_74742_a((NBTBase)nbt);
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74782_a("list", (NBTBase)tagList);
        try {
            EncoderHandler.encode(customPacketBuffer, nbtTagCompound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        customPacketBuffer.writeBoolean(this.colony != null);
        if (this.colony != null) {
            customPacketBuffer.writeBytes((ByteBuf)this.colony.writePacket());
            List sends = SpaceNet.instance.getColonieNet().getSendsFromUUID(this.player).stream().filter(sends1 -> sends1.getBody() == this.colony.getBody()).collect(Collectors.toList());
            InfoSends infoSends = new InfoSends();
            for (Sends send : sends) {
                infoSends.addTimer(send.getTimerToPlanet());
            }
            customPacketBuffer.writeBytes((ByteBuf)infoSends.writeBuffer());
        }
        return customPacketBuffer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiResearchTableSpace(this.getGuiContainer(var1));
    }

    public ContainerResearchTableSpace getGuiContainer(EntityPlayer var1) {
        return new ContainerResearchTableSpace(this, var1);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().func_72820_D() % 80L == 0L) {
            MinecraftForge.EVENT_BUS.post((Event)new ResearchTableReLoadEvent(this.func_145831_w(), this));
        }
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timer == 0) {
            if (this.body != null || this.fakeBody != null) {
                new PacketUpdateFakeBody(this, null);
            }
            this.body = null;
            this.fakeBody = null;
        }
        if (this.func_145831_w().func_72820_D() % 20L == 0L) {
            boolean find = false;
            if (this.body != null) {
                List<Object> list;
                if (this.colony != null) {
                    if (!this.colony.matched(this.body)) {
                        list = SpaceNet.instance.getColonieNet().getMap().get(this.player);
                        this.colony = list == null || list.isEmpty() ? null : ((list = list.stream().filter(colony -> colony.matched(this.body)).collect(Collectors.toList())).isEmpty() ? null : (IColony)list.get(0));
                    }
                } else {
                    list = SpaceNet.instance.getColonieNet().getMap().get(this.player);
                    if (list != null && !list.isEmpty() && !(list = list.stream().filter(colony -> colony.matched(this.body)).collect(Collectors.toList())).isEmpty()) {
                        this.colony = (IColony)list.get(0);
                    }
                }
                list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(this.player, k -> new LinkedList());
                for (IFakeBody fakeBody : list) {
                    if (!fakeBody.matched(this.body)) continue;
                    this.fakeBody = fakeBody;
                    new PacketUpdateFakeBody(this, this.fakeBody);
                    find = true;
                    break;
                }
                if (!find) {
                    this.fakeBody = null;
                    new PacketUpdateFakeBody(this, null);
                }
            } else {
                this.colony = null;
            }
        }
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof EntityPlayer) {
            this.player = placer.func_110124_au();
        }
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        switch (this.getFacing()) {
            case EAST: {
                return aabbs_east;
            }
            case SOUTH: {
                return aabbs_south;
            }
            case WEST: {
                return aabbs_west;
            }
            case NORTH: {
                return aabbs_north;
            }
        }
        return aabbs;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.player = nbtTagCompound.func_186857_a("player");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_186854_a("player", this.player);
        return nbtTagCompound;
    }

    @Override
    public Map<IBody, SpaceOperation> getSpaceBody() {
        if (this.operationMap == null) {
            this.operationMap = SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(this.player);
        }
        return this.operationMap;
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    @Override
    public EnumLevels getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(EnumLevels level) {
        this.level = level;
    }
}

