/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.research.event.RocketPadLoadEvent;
import com.denfop.api.space.research.event.RocketPadReLoadEvent;
import com.denfop.api.space.research.event.RocketPadUnLoadEvent;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerRocketLaunchPad;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.gui.GuiRocketLaunchPad;
import com.denfop.invslot.InvSlot;
import com.denfop.items.space.ItemRover;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.rocketpad.DataRocket;
import com.denfop.render.rocketpad.RocketPadRender;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRocketLaunchPad
extends TileEntityInventory
implements IRocketLaunchPad {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 2.0, 2.0));
    public final InvSlotOutput outputSlot;
    public final InvSlot roverSlot;
    public final Energy energy;
    public final Fluids fluids;
    public final Fluids.InternalFluidTank tank;
    public final Fluids.InternalFluidTank[] tanks;
    public List<DataRocket> rocketList = new ArrayList<DataRocket>();
    boolean added = false;
    private UUID player;
    @SideOnly(value=Side.CLIENT)
    private RocketPadRender render;

    public TileEntityRocketLaunchPad() {
        this.outputSlot = new InvSlotOutput(this, 27);
        this.roverSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof IRoversItem;
            }
        };
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 40000, Fluids.fluidPredicate(FluidName.fluidhydrazine.getInstance(), FluidName.fluiddimethylhydrazine.getInstance(), FluidName.fluiddecane.getInstance(), FluidName.fluidxenon.getInstance()));
        this.tanks = new Fluids.InternalFluidTank[9];
        for (int i = 0; i < 9; ++i) {
            this.tanks[i] = this.fluids.addTankExtract("tank" + i, 10000);
        }
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 5000000.0, 14));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.rocket_launch_pad;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().func_72820_D() % 80L == 0L) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketPadReLoadEvent(this.func_145831_w(), this));
        }
        if (!this.roverSlot.isEmpty()) {
            this.charge(this.roverSlot.get());
            this.refuel(this.roverSlot.get(), (IRoversItem)this.roverSlot.get().func_77973_b());
        }
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof EntityPlayer) {
            this.player = placer.func_110124_au();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.player = nbtTagCompound.func_186857_a("player");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_186854_a("player", this.player);
        return nbtTagCompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.func_145831_w().field_72995_K) {
            GlobalRenderManager.addRender(this.field_145850_b, this.field_174879_c, this.createFunction(this));
        } else if (!this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketPadLoadEvent(this.func_145831_w(), this));
            this.added = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Function createFunction(TileEntityRocketLaunchPad te) {
        Function<Object, Object> function = o -> {
            if (this.render == null) {
                this.render = new RocketPadRender();
            }
            this.render.render(te);
            return 0;
        };
        return function;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketPadUnLoadEvent(this.func_145831_w(), this));
            this.added = false;
        }
        if (this.func_145831_w().field_72995_K) {
            GlobalRenderManager.removeRender(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void refuel(ItemStack itemStack, IRoversItem roversItem) {
        IFluidHandlerItem fluidHandler = roversItem.getFluidHandler(itemStack);
        if (this.tank.getFluidAmount() > 0 && fluidHandler.fill(this.tank.getFluid(), false) > 0) {
            this.tank.drain(fluidHandler.fill(this.tank.getFluid(), true), true);
        }
    }

    @Override
    public void charge(ItemStack itemStack) {
        if (this.energy.getEnergy() > 0.0) {
            this.energy.useEnergy(ElectricItem.manager.charge(itemStack, this.energy.getEnergy(), 14, true, false));
        }
    }

    @Override
    public ItemStack getRoverStack() {
        return this.roverSlot.get();
    }

    @Override
    public InvSlot getRoverSlot() {
        return this.roverSlot;
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    @Override
    public World getWorldPad() {
        return this.field_145850_b;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = super.writePacket();
        packetBuffer.writeBoolean(this.roverSlot.isEmpty());
        if (!this.roverSlot.isEmpty()) {
            packetBuffer.func_150788_a(this.roverSlot.get());
        }
        return packetBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        boolean isNotEmpty = customPacketBuffer.readBoolean();
        if (!isNotEmpty) {
            try {
                this.roverSlot.put(0, customPacketBuffer.func_150791_c());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("datarocket")) {
            try {
                ItemStack stack = is.func_150791_c();
                this.rocketList.add(new DataRocket((IRoversItem)stack.func_77973_b(), this.field_174879_c.func_177956_o()));
                this.roverSlot.put(0, ItemStack.field_190927_a);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addDataRocket(ItemStack stack) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeString("datarocket");
        packetBuffer.func_150788_a(stack);
        IUCore.network.getServer().addTileFieldToUpdate(this, packetBuffer);
    }

    @Override
    public InvSlotOutput getSlotOutput() {
        return this.outputSlot;
    }

    @Override
    public void addFluidStack(FluidStack fluidStack) {
        for (int i = 0; i < 9; ++i) {
            Fluids.InternalFluidTank tank = this.tanks[i];
            if (tank.fill(fluidStack, false) <= 0) continue;
            tank.fill(fluidStack, true);
            break;
        }
    }

    public ContainerRocketLaunchPad getGuiContainer(EntityPlayer var1) {
        return new ContainerRocketLaunchPad(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiRocketLaunchPad(this.getGuiContainer(var1));
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && !(player.func_184586_b(hand).func_77973_b() instanceof ItemRover)) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public IRoversItem getRover() {
        if (this.roverSlot.get().func_190926_b()) {
            return null;
        }
        return (IRoversItem)this.roverSlot.get().func_77973_b();
    }

    @Override
    public void consumeRover() {
        this.roverSlot.put(0, ItemStack.field_190927_a);
    }
}

