/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerSaplingGardener;
import com.denfop.gui.GuiSaplingGardener;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySaplingGardener
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    public final InvSlot slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof IPlantable && ((IPlantable)((ItemBlock)stack.func_77973_b()).func_179223_d()).getPlantType((IBlockAccess)TileEntitySaplingGardener.this.field_145850_b, TileEntitySaplingGardener.this.getBlockPos()) == EnumPlantType.Plains;
        }
    };
    public final Energy energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));

    public TileEntitySaplingGardener() {
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.sapling_gardener;
    }

    public ContainerSaplingGardener getGuiContainer(EntityPlayer var1) {
        return new ContainerSaplingGardener(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSaplingGardener(this.getGuiContainer(var1));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
            this.plantSaplingsInRadius();
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.sapling_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    private void plantSaplingsInRadius() {
        for (int x = -4; x <= 4; x += 2) {
            for (int z = -4; z <= 4; z += 2) {
                ItemStack saplingStack;
                BlockPos targetPos = this.field_174879_c.func_177982_a(x, 0, z);
                if (!this.canPlantSaplingAt(targetPos) || !this.energy.canUseEnergy(25.0) || (saplingStack = this.slot.get()).func_190926_b()) continue;
                this.energy.useEnergy(25.0);
                this.plantSapling(targetPos, saplingStack);
                if (!(this.energy.getEnergy() < 25.0)) continue;
                return;
            }
        }
    }

    private boolean canPlantSaplingAt(BlockPos pos) {
        Block blockAt = this.field_145850_b.func_180495_p(pos).func_177230_c();
        if (blockAt != Blocks.field_150350_a) {
            return false;
        }
        Block blockBelow = this.field_145850_b.func_180495_p(pos.func_177977_b()).func_177230_c();
        return blockBelow == Blocks.field_150346_d || blockBelow == Blocks.field_150349_c;
    }

    private void plantSapling(BlockPos targetPos, ItemStack saplingStack) {
        Block block = ((ItemBlock)saplingStack.func_77973_b()).func_179223_d();
        if (block instanceof IGrowable) {
            this.field_145850_b.func_175656_a(targetPos, block.func_176203_a(saplingStack.func_77952_i()));
            saplingStack.func_190918_g(1);
        }
    }
}

