/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerSheepFarm;
import com.denfop.gui.GuiSheepFarm;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySheepFarm
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    private static final int MAX_SHEEP = 20;
    public final InvSlot slotSeeds;
    public final InvSlotOutput output;
    public final Energy energy;
    public final InvSlotUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    AxisAlignedBB searchArea;
    List<Chunk> chunks;

    public TileEntitySheepFarm() {
        this.searchArea = new AxisAlignedBB(this.field_174879_c.func_177982_a(-4, -4, -4), this.field_174879_c.func_177982_a(4, 4, 4));
        this.chunks = new ArrayList<Chunk>();
        this.slotSeeds = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() == Items.field_151015_O;
            }
        };
        this.output = new InvSlotOutput(this, 9);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    public <T extends Entity> List<T> getEntitiesWithinAABB(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        ArrayList list = Lists.newArrayList();
        this.chunks.forEach(chunk -> chunk.func_177430_a(clazz, aabb, list, filter));
        return list;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    public ContainerSheepFarm getGuiContainer(EntityPlayer var1) {
        return new ContainerSheepFarm(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSheepFarm(this.getGuiContainer(var1));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.sheep_farm;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            AxisAlignedBB aabb;
            this.searchArea = aabb = this.searchArea.func_186670_a(this.field_174879_c);
            int j2 = MathHelper.func_76128_c((double)((aabb.field_72340_a - 2.0) / 16.0));
            int k2 = MathHelper.func_76143_f((double)((aabb.field_72336_d + 2.0) / 16.0));
            int l2 = MathHelper.func_76128_c((double)((aabb.field_72339_c - 2.0) / 16.0));
            int i3 = MathHelper.func_76143_f((double)((aabb.field_72334_f + 2.0) / 16.0));
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    Chunk chunk = this.field_145850_b.func_72964_e(j3, k3);
                    if (this.chunks.contains(chunk)) continue;
                    this.chunks.add(chunk);
                }
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.sheep_farm.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            this.energy.useEnergy(50.0);
            List<EntitySheep> sheepList = this.getEntitiesWithinAABB(EntitySheep.class, this.searchArea, EntitySelectors.field_180132_d);
            this.shearSheep(sheepList);
            if (sheepList.size() < 20) {
                this.breedSheep(sheepList);
            }
            if (sheepList.size() > 20) {
                this.killExcessSheep(sheepList);
            }
        }
    }

    private void killExcessSheep(List<EntitySheep> sheepList) {
        for (int i = sheepList.size() - 1; i >= 20; --i) {
            EntitySheep sheep = sheepList.get(i);
            sheep.func_70106_y();
            this.output.add(new ItemStack(Items.field_179561_bm, 1));
        }
    }

    private void breedSheep(List<EntitySheep> sheepList) {
        block0: for (int i = 0; i < sheepList.size(); ++i) {
            for (int j = i + 1; j < sheepList.size(); ++j) {
                EntitySheep sheep1 = sheepList.get(i);
                EntitySheep sheep2 = sheepList.get(j);
                if (sheep1.func_70874_b() != 0 || this.slotSeeds.get().func_190916_E() < 2 || sheep1.func_70880_s() || sheep2.func_70880_s() || sheep2.func_70874_b() != 0 || sheep1.func_191993_do() != null || sheep2.func_191993_do() != null) continue;
                sheep1.func_146082_f(null);
                sheep2.func_146082_f(null);
                this.slotSeeds.get().func_190918_g(2);
                continue block0;
            }
        }
    }

    private void shearSheep(List<EntitySheep> sheepList) {
        for (EntitySheep sheep : sheepList) {
            if (sheep.func_70892_o() || !sheep.func_70089_S()) continue;
            sheep.func_70893_e(true);
            ItemStack wool = new ItemStack(Blocks.field_150325_L, this.field_145850_b.field_73012_v.nextInt(2) + 1, sheep.func_175509_cj().func_176765_a());
            this.output.add(wool);
        }
    }
}

