/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerShield;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.gui.GuiShield;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.ItemEntityModule;
import com.denfop.network.DecoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.CapturedMobUtils;
import com.denfop.utils.ModUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class TileEntityShield
extends TileEntityInventory
implements IUpdatableTileEvent {
    final int latitudeSegments = 16;
    final int longitudeSegments = 16;
    private final InvSlot slot;
    public boolean visibleShield = false;
    public boolean visibleLaser = false;
    Energy energy;
    List<Integer> integerList = new LinkedList<Integer>();
    AxisAlignedBB shieldBox;
    AxisAlignedBB shieldDefaultBox = new AxisAlignedBB(-8.0, -8.0, -8.0, 8.0, 8.0, 8.0);
    Vec3d center;
    LinkedList<Chunk> chunks = new LinkedList();
    List<UUID> uuidList = new LinkedList<UUID>();
    double[] sinLat = new double[17];
    double[] cosLat = new double[17];
    double[] sinLng = new double[17];
    double[] cosLng = new double[17];
    boolean write = false;
    double[][] x1 = new double[16][16];
    double[][] x2 = new double[16][16];
    double[][] x3 = new double[16][16];
    double[][] x4 = new double[16][16];
    double[][] y1 = new double[16][16];
    double[][] y2 = new double[16][16];
    double[][] y3 = new double[16][16];
    double[][] y4 = new double[16][16];
    double[][] z1 = new double[16][16];
    double[][] z2 = new double[16][16];
    double[][] z3 = new double[16][16];
    double[][] z4 = new double[16][16];
    @SideOnly(value=Side.CLIENT)
    private Function render;
    private double laserProgress;
    private byte mode = 0;
    private long lastShotTime = 0L;
    private boolean isShooting = false;

    public TileEntityShield() {
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 10000.0, 14));
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 9){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.func_77973_b() instanceof ItemEntityModule)) {
                    return false;
                }
                if (stack.func_77952_i() == 0) {
                    return false;
                }
                return CapturedMobUtils.containsSoul(stack);
            }

            @Override
            public void update() {
                super.update();
                TileEntityShield.this.integerList.clear();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).func_190926_b()) continue;
                    CapturedMobUtils captured = CapturedMobUtils.create(this.get(i));
                    assert (captured != null);
                    EntityLiving entityLiving = (EntityLiving)captured.getEntity(((TileEntityShield)this.base).func_145831_w(), true);
                    TileEntityShield.this.integerList.add(entityLiving.func_145782_y());
                }
            }
        };
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("VisibleShield", this.visibleShield);
        compound.func_74757_a("VisibleLaser", this.visibleLaser);
        compound.func_74774_a("Mode", this.mode);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.visibleShield = compound.func_74767_n("VisibleShield");
        this.visibleLaser = compound.func_74767_n("VisibleLaser");
        this.mode = compound.func_74771_c("Mode");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.slot.update();
        this.shieldBox = new AxisAlignedBB(this.func_174877_v().func_177982_a(-8, -8, -8), this.func_174877_v().func_177982_a(8, 8, 8));
        this.center = new Vec3d((Vec3i)this.func_174877_v()).func_178787_e(new Vec3d(0.0, 0.5, 0.0));
        int j2 = MathHelper.func_76128_c((double)((this.shieldBox.field_72340_a - 2.0) / 16.0));
        int k2 = MathHelper.func_76143_f((double)((this.shieldBox.field_72336_d + 2.0) / 16.0));
        int l2 = MathHelper.func_76128_c((double)((this.shieldBox.field_72339_c - 2.0) / 16.0));
        int i3 = MathHelper.func_76143_f((double)((this.shieldBox.field_72334_f + 2.0) / 16.0));
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                Chunk chunk = this.field_145850_b.func_72964_e(j3, k3);
                if (this.chunks.contains(chunk)) continue;
                this.chunks.add(chunk);
            }
        }
        if (this.func_145831_w().field_72995_K) {
            this.render = this.createFunction();
            GlobalRenderManager.addRender(this.func_145831_w(), this.field_174879_c, this.render);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.func_145831_w().field_72995_K) {
            GlobalRenderManager.removeRender(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("uuid")) {
            try {
                UUID uuid = (UUID)DecoderHandler.decode(is);
                this.uuidList.add(uuid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visibleShield")) {
            try {
                this.visibleShield = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visibleLaser")) {
            try {
                this.visibleLaser = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mode")) {
            try {
                this.mode = (Byte)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Function createFunction() {
        Function<Object, Object> function = o -> {
            int shieldColor;
            List<Entity> mobs;
            if (this.shieldBox == null) {
                this.shieldBox = new AxisAlignedBB(this.func_174877_v().func_177982_a(-8, -8, -8), this.func_174877_v().func_177982_a(8, 8, 8));
                this.center = new Vec3d((Vec3i)this.func_174877_v()).func_178787_e(new Vec3d(0.0, 0.5, 0.0));
                int j2 = MathHelper.func_76128_c((double)((this.shieldBox.field_72340_a - 2.0) / 16.0));
                int k2 = MathHelper.func_76143_f((double)((this.shieldBox.field_72336_d + 2.0) / 16.0));
                int l2 = MathHelper.func_76128_c((double)((this.shieldBox.field_72339_c - 2.0) / 16.0));
                int i3 = MathHelper.func_76143_f((double)((this.shieldBox.field_72334_f + 2.0) / 16.0));
                for (int j3 = j2; j3 < k2; ++j3) {
                    for (int k3 = l2; k3 < i3; ++k3) {
                        Chunk chunk = this.field_145850_b.func_72964_e(j3, k3);
                        if (this.chunks.contains(chunk)) continue;
                        this.chunks.add(chunk);
                    }
                }
            }
            boolean mobNearby = !(mobs = this.getEntitiesWithinAABB(Entity.class, this.shieldBox, e -> {
                boolean hasmob = e instanceof EntityMob;
                if (this.mode == 0) {
                    return hasmob && !this.integerList.contains(e.func_145782_y());
                }
                return hasmob && this.integerList.contains(e.func_145782_y());
            })).isEmpty();
            int n = shieldColor = mobNearby ? ModUtils.convertRGBcolorToInt(168, 0, 0) : 65535;
            if (this.visibleShield) {
                this.renderShield(this.shieldBox, shieldColor);
            }
            if (mobNearby && this.visibleLaser) {
                mobs.forEach(this::renderLaserEffect);
            }
            this.uuidList.clear();
            return 0;
        };
        return function;
    }

    public <T extends Entity> List<T> getEntitiesWithinAABB(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        ArrayList list = Lists.newArrayList();
        this.chunks.forEach(chunk -> chunk.func_177430_a(clazz, aabb, list, filter));
        return list;
    }

    public InvSlot getSlot() {
        return this.slot;
    }

    public byte getMode() {
        return this.mode;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy.getEnergy() >= 25.0) {
            boolean mobNearby;
            List<Entity> mobs = this.getEntitiesWithinAABB(Entity.class, this.shieldBox, e -> {
                boolean hasmob = e instanceof EntityMob;
                if (this.mode == 0) {
                    return hasmob && !this.integerList.contains(e.func_145782_y());
                }
                return hasmob && this.integerList.contains(e.func_145782_y());
            });
            boolean bl = mobNearby = !mobs.isEmpty();
            if (mobNearby) {
                for (Entity entity : mobs) {
                    if (!(this.energy.getEnergy() >= 25.0)) break;
                    new PacketUpdateFieldTile(this, "uuid", entity.func_110124_au());
                    entity.func_70097_a(DamageSource.field_76376_m, 4.0f);
                    this.energy.useEnergy(25.0);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderShield(AxisAlignedBB box, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        Color color1 = new Color(color);
        GlStateManager.func_179131_c((float)color1.getRed(), (float)color1.getGreen(), (float)color1.getBlue(), (float)0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        if (!this.write) {
            this.writeData();
        }
        this.drawCircle(buffer, this.field_174879_c, tessellator);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private void writeData() {
        int i;
        this.write = true;
        for (i = 0; i <= 16; ++i) {
            double lat = Math.PI * (-0.5 + (double)i / 16.0);
            this.sinLat[i] = Math.sin(lat);
            this.cosLat[i] = Math.cos(lat);
        }
        for (int j = 0; j <= 16; ++j) {
            double lng = Math.PI * 2 * (double)j / 16.0;
            this.sinLng[j] = Math.sin(lng);
            this.cosLng[j] = Math.cos(lng);
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.x1[i][j] = this.cosLng[j] * this.cosLat[i];
                this.y1[i][j] = this.sinLat[i];
                this.z1[i][j] = this.sinLng[j] * this.cosLat[i];
                this.x2[i][j] = this.cosLng[j] * this.cosLat[i + 1];
                this.y2[i][j] = this.sinLat[i + 1];
                this.z2[i][j] = this.sinLng[j] * this.cosLat[i + 1];
                this.x3[i][j] = this.cosLng[j + 1] * this.cosLat[i + 1];
                this.y3[i][j] = this.sinLat[i + 1];
                this.z3[i][j] = this.sinLng[j + 1] * this.cosLat[i + 1];
                this.x4[i][j] = this.cosLng[j + 1] * this.cosLat[i];
                this.y4[i][j] = this.sinLat[i];
                this.z4[i][j] = this.sinLng[j + 1] * this.cosLat[i];
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawCircle(BufferBuilder buffer, BlockPos pos, Tessellator tessellator) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        buffer.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                double x1 = this.x1[i][j];
                double y1 = this.y1[i][j];
                double z1 = this.z1[i][j];
                double x2 = this.x2[i][j];
                double y2 = this.y2[i][j];
                double z2 = this.z2[i][j];
                double x3 = this.x3[i][j];
                double y3 = this.y3[i][j];
                double z3 = this.z3[i][j];
                double x4 = this.x4[i][j];
                double y4 = this.y4[i][j];
                double z4 = this.z4[i][j];
                buffer.func_181662_b(x + x1 * this.shieldDefaultBox.field_72336_d, y + y1 * this.shieldDefaultBox.field_72337_e, z + z1 * this.shieldDefaultBox.field_72334_f).func_181675_d();
                buffer.func_181662_b(x + x2 * this.shieldDefaultBox.field_72336_d, y + y2 * this.shieldDefaultBox.field_72337_e, z + z2 * this.shieldDefaultBox.field_72334_f).func_181675_d();
                buffer.func_181662_b(x + x3 * this.shieldDefaultBox.field_72336_d, y + y3 * this.shieldDefaultBox.field_72337_e, z + z3 * this.shieldDefaultBox.field_72334_f).func_181675_d();
                buffer.func_181662_b(x + x3 * this.shieldDefaultBox.field_72336_d, y + y3 * this.shieldDefaultBox.field_72337_e, z + z3 * this.shieldDefaultBox.field_72334_f).func_181675_d();
                buffer.func_181662_b(x + x4 * this.shieldDefaultBox.field_72336_d, y + y4 * this.shieldDefaultBox.field_72337_e, z + z4 * this.shieldDefaultBox.field_72334_f).func_181675_d();
                buffer.func_181662_b(x + x1 * this.shieldDefaultBox.field_72336_d, y + y1 * this.shieldDefaultBox.field_72337_e, z + z1 * this.shieldDefaultBox.field_72334_f).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderLaserEffect(Entity entity) {
        Vec3d start = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        Vec3d end = entity.func_174791_d().func_72441_c(0.0, (double)entity.field_70131_O / 2.0, 0.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)0.8f);
        GlStateManager.func_187441_d((float)32.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
        GL11.glVertex3d((double)end.field_72450_a, (double)end.field_72448_b, (double)end.field_72449_c);
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        if (this.uuidList.remove(entity.func_110124_au())) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastShotTime > 1000L) {
                this.lastShotTime = currentTime;
                this.isShooting = true;
                this.laserProgress = 0.0;
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
            }
            if (this.isShooting) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.0f, (float)1.0f);
                GlStateManager.func_187441_d((float)8.0f);
                double segmentLength = 0.5;
                Vec3d direction = end.func_178788_d(start).func_72432_b();
                double totalDistance = start.func_72438_d(end);
                double currentDistance = this.laserProgress * totalDistance;
                Vec3d segmentStart = start.func_178787_e(direction.func_186678_a(currentDistance));
                Vec3d segmentEnd = start.func_178787_e(direction.func_186678_a(Math.min(currentDistance + segmentLength, totalDistance)));
                GL11.glBegin((int)1);
                GL11.glVertex3d((double)segmentStart.field_72450_a, (double)segmentStart.field_72448_b, (double)segmentStart.field_72449_c);
                GL11.glVertex3d((double)segmentEnd.field_72450_a, (double)segmentEnd.field_72448_b, (double)segmentEnd.field_72449_c);
                GL11.glEnd();
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
                this.spawnLaserParticles(segmentStart, segmentEnd);
                this.laserProgress += 0.1;
                if (this.laserProgress >= 1.0) {
                    this.isShooting = false;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLaserParticles(Vec3d start, Vec3d end) {
        double step = 0.1;
        double distance = start.func_72438_d(end);
        Vec3d direction = end.func_178788_d(start).func_72432_b();
        for (double i = 0.0; i < distance; i += step) {
            Vec3d particlePos = start.func_178787_e(direction.func_186678_a(i));
            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public ContainerShield getGuiContainer(EntityPlayer var1) {
        return new ContainerShield(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiShield(this.getGuiContainer(var1));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.shield;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == 0.0) {
            this.visibleLaser = true;
            new PacketUpdateFieldTile(this, "visibleLaser", this.visibleLaser);
        }
        if (var2 == 1.0) {
            this.visibleShield = true;
            new PacketUpdateFieldTile(this, "visibleShield", this.visibleShield);
        }
        if (var2 == -1.0) {
            this.visibleLaser = false;
            new PacketUpdateFieldTile(this, "visibleLaser", this.visibleLaser);
        }
        if (var2 == -2.0) {
            this.visibleShield = false;
            new PacketUpdateFieldTile(this, "visibleShield", this.visibleShield);
        }
        if (var2 == 2.0) {
            this.mode = 0;
            new PacketUpdateFieldTile(this, "mode", this.mode);
        }
        if (var2 == 3.0) {
            this.mode = 1;
            new PacketUpdateFieldTile(this, "mode", this.mode);
        }
    }
}

