/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerSoilAnalyzer;
import com.denfop.gui.GuiSoilAnalyzer;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySoilAnalyzer
extends TileElectricMachine {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(-0.2, 0.0, -0.2, 1.2, 2.0, 1.2));
    public final ComponentProgress progress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 400));
    private final SoilPollutionComponent pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
    private final AirPollutionComponent pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.05));
    public boolean analyzed = false;
    public Radiation radiation;

    public TileEntitySoilAnalyzer() {
        super(5000.0, 14, 0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("analyzed", this.analyzed);
        return nbttagcompound;
    }

    public ContainerSoilAnalyzer getGuiContainer(EntityPlayer var1) {
        return new ContainerSoilAnalyzer(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSoilAnalyzer(this.getGuiContainer(var1));
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.analyzed);
        customPacketBuffer.writeBoolean(this.radiation != null);
        if (this.radiation != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.radiation);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.analyzed = customPacketBuffer.readBoolean();
        boolean notNull = customPacketBuffer.readBoolean();
        if (notNull) {
            try {
                this.radiation = (Radiation)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.analyzed = nbttagcompound.func_74767_n("analyzed");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy.getEnergy() > 20.0 && this.progress.getBar() < 1.0) {
            this.energy.useEnergy(20.0);
            this.progress.addProgress();
            if (this.progress.getProgress() >= this.progress.getMaxValue()) {
                this.analyzed = true;
                this.radiation = RadiationSystem.rad_system.getMap().get(this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l());
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K && this.analyzed) {
            this.radiation = RadiationSystem.rad_system.getMap().get(this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l());
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.soil_analyzer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return aabbs;
    }
}

