/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockSqueezer;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntitySqueezer
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, -0.5, 1.0, 1.7, 1.5));
    private static final List<AxisAlignedBB> aabbs1 = Collections.singletonList(new AxisAlignedBB(-0.5, 0.0, 0.0, 1.5, 1.7, 1.0));
    public final InvSlotRecipes inputSlotA;
    public final Fluids.InternalFluidTank fluidTank1;
    public final InvSlotFluidByList fluidSlot1;
    public final FluidHandlerRecipe fluid_handler;
    public short progress = 0;
    public Map<UUID, Double> data = PrimitiveHandler.getPlayersData(EnumPrimitive.SQUEEZER);
    private MachineRecipe output;

    public TileEntitySqueezer() {
        this.inputSlotA = new InvSlotRecipes(this, "squeezer", this){

            @Override
            public boolean accepts(ItemStack itemStack, int index) {
                if (index == 4) {
                    return super.accepts(itemStack, 0);
                }
                return false;
            }
        };
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTank("fluidTank1", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("squeezer", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot1.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.inputSlotA.setStackSizeLimit(1);
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addRecipe(ItemStack container, FluidStack fluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("squeezer", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, container)));
        Recipes.recipes.getRecipeFluid().addRecipe("squeezer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container), Collections.singletonList(fluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 5; ++i) {
            tooltip.add(Localization.translate("squeezer.info" + i));
        }
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) && capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void init() {
        TileEntitySqueezer.addRecipe(new ItemStack((Item)IUItem.rawLatex), new FluidStack(FluidName.fluidrawlatex.getInstance(), 100));
        TileEntitySqueezer.addRecipe(new ItemStack(Items.field_151014_N), new FluidStack(FluidName.fluidseedoil.getInstance(), 10));
        TileEntitySqueezer.addRecipe(new ItemStack(Items.field_151081_bc), new FluidStack(FluidName.fluidseedoil.getInstance(), 35));
        TileEntitySqueezer.addRecipe(new ItemStack(Items.field_151080_bb), new FluidStack(FluidName.fluidseedoil.getInstance(), 35));
        TileEntitySqueezer.addRecipe(new ItemStack((Item)IUItem.crops), new FluidStack(FluidName.fluidseedoil.getInstance(), 50));
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        if (this.facing != 4 && this.facing != 5) {
            return aabbs1;
        }
        return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, -0.5, 1.0, 1.7, 1.5));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.squeezer;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSqueezer.squeezer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.SQUEEZER);
        if (IUCore.proxy.isSimulating()) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get());
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.put(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (stack.func_77973_b().equals(IUItem.treetap) && !this.inputSlotA.isEmpty() && this.output != null && this.fluid_handler.output() != null && this.fluid_handler.canFillFluid()) {
            this.progress = (short)(this.progress + (short)(10 + (short)(this.data.getOrDefault(player.func_110124_au(), 0.0) / 2.5)));
            this.getCooldownTracker().setTick(8);
            this.setActive(String.valueOf(this.progress / 10));
            if (this.progress >= 150) {
                this.progress = 0;
                this.setActive("");
                if (!this.func_145831_w().field_72995_K) {
                    PrimitiveHandler.addExperience(EnumPrimitive.SQUEEZER, 0.5, player.func_110124_au());
                }
                this.fluid_handler.fillFluid();
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                }
            }
            return this.func_145831_w().field_72995_K;
        }
        if (!stack.func_190926_b() && this.inputSlotA.accepts(stack, 4)) {
            if (this.inputSlotA.get(0).func_190926_b()) {
                ItemStack stack1 = stack.func_77946_l();
                stack1.func_190920_e(1);
                this.inputSlotA.put(0, stack1);
                stack.func_190918_g(1);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && this.fluidTank1.getFluidAmount() >= 1000) {
                ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.inputSlotA.get(), player);
                }
                this.inputSlotA.put(0, ItemStack.field_190927_a);
                this.output = null;
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && !this.inputSlotA.isEmpty()) {
            this.fluid_handler.getOutput(this.inputSlotA.get());
        } else if (this.fluid_handler.output() != null && this.inputSlotA.isEmpty()) {
            this.fluid_handler.setOutput(null);
        }
    }
}

