/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerTripleSolidMixer;
import com.denfop.gui.GuiTripleSolidMixer;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityTripleSolidMixer
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotRecipes inputSlotA;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    protected short progress;

    public TileEntityTripleSolidMixer() {
        super(200.0, 1, 3);
        Recipes.recipes.addInitRecipes(this);
        this.progress = 0;
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationLength = 200;
        this.defaultOperationLength = 200;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "triple_solid_mixer", (IUpdateTick)this);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    public static void addRecipe(ItemStack container, ItemStack container1, ItemStack container2, ItemStack output, ItemStack output1) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("triple_solid_mixer", new BaseMachineRecipe(new Input(input.getInput(container), input.getInput(container1), input.getInput(container2)), new RecipeOutput(null, output, output1)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 200 + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + 1);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.solid_mixer.getSoundEvent();
    }

    public ContainerTripleSolidMixer getGuiContainer(EntityPlayer var1) {
        return new ContainerTripleSolidMixer(var1, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiTripleSolidMixer(this.getGuiContainer(var1));
    }

    @Override
    public void init() {
        TileEntityTripleSolidMixer.addRecipe(new ItemStack((Item)IUItem.iudust, 2, 66), new ItemStack((Item)IUItem.iudust, 6, 60), new ItemStack((Item)IUItem.iudust, 10, 21), new ItemStack((Item)IUItem.iudust, 6, 71), new ItemStack((Item)IUItem.white_phosphorus));
        TileEntityTripleSolidMixer.addRecipe(new ItemStack((Item)IUItem.nuclear_res, 1, 21), new ItemStack((Item)IUItem.iudust, 3, 55), new ItemStack((Item)IUItem.iudust, 1, 62), new ItemStack(IUItem.crushed, 1, 24), IUItem.stoneDust);
        TileEntityTripleSolidMixer.addRecipe(new ItemStack((Item)IUItem.iudust, 2, 33), new ItemStack((Item)IUItem.iudust, 1, 59), new ItemStack((Item)IUItem.crafting_elements, 3, 499), new ItemStack((Item)IUItem.graphene), new ItemStack((Item)IUItem.iudust, 1, 31));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.triple_solid_mixer;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.output != null && !this.inputSlotA.isEmpty() && this.inputSlotA.continue_process(this.output) && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items) && this.energy.canUseEnergy(this.energyConsume)) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.outputSlot.addWithoutIgnoring(this.output.getRecipe().getOutput().items, false);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput, UpgradableProperty.ItemExtract);
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

