/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.crafting.BaseRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerUpgradeMachineFactory;
import com.denfop.gui.GuiUpgradeMachineFactory;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityUpgradeMachineFactory
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    public final InvSlotRecipes inputSlotA;
    public final ComponentUpgrade componentUpgrades;
    public MachineRecipe output;

    public TileEntityUpgradeMachineFactory() {
        super(400.0, 1, 1);
        Recipes.recipes.addInitRecipes(this);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 200));
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "upgrade_machine", (IUpdateTick)this);
        this.inputSlotA.setStackSizeLimit(1);
        this.componentProcess = this.addComponent(new ComponentProcess(this, 200, 1.0));
        this.componentProcess.setHasAudio(false);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    public static void addRecipe(BaseRecipe baseRecipe, int upgrade) {
        NonNullList<Ingredient> ingredients = baseRecipe.func_192400_c();
        ItemStack outputStack = baseRecipe.getOutput();
        ItemStack input_mechanism = ((Ingredient)ingredients.get(4)).func_193365_a()[0];
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        ItemStack upgradeStack = new ItemStack(IUItem.machinekit, 1, upgrade);
        for (Ingredient ingredient : ingredients) {
            if (ingredient.equals(Ingredient.field_193370_a)) {
                inputs.add(new InputItemStack(ItemStack.field_190927_a));
                continue;
            }
            ItemStack input = ingredient.func_193365_a()[0];
            if (input.func_77969_a(input_mechanism)) {
                inputs.add(new InputItemStack(upgradeStack.func_77946_l()));
                continue;
            }
            inputs.add(new InputItemStack(input));
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        outputStack.func_77955_b(tagCompound);
        NBTTagCompound tagCompound2 = new NBTTagCompound();
        input_mechanism.func_77955_b(tagCompound2);
        NBTTagCompound tagCompound1 = ModUtils.nbt(upgradeStack);
        tagCompound1.func_74782_a("output", (NBTBase)tagCompound);
        tagCompound1.func_74782_a("input", (NBTBase)tagCompound2);
        Recipes.recipes.addRecipe("upgrade_machine", new BaseMachineRecipe(new Input(inputs), new RecipeOutput(null, upgradeStack)));
    }

    @Override
    public void init() {
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerUpgradeMachineFactory getGuiContainer(EntityPlayer var1) {
        return new ContainerUpgradeMachineFactory(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiUpgradeMachineFactory(this.getGuiContainer(var1));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.upgrade_machine;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

