/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerWirelessControllerReactors;
import com.denfop.gui.GuiWirelessControllerReactors;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemReactorData;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.ModUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityWirelessControllerReactors
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlot invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<TileMultiBlockBase> tileMultiBlockBaseList = new LinkedList<TileMultiBlockBase>();

    public TileEntityWirelessControllerReactors() {
        this.invslot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 12){

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                TileEntityWirelessControllerReactors.this.updateList();
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.func_77973_b() instanceof ItemReactorData)) {
                    return false;
                }
                NBTTagCompound nbt = ModUtils.nbt(stack);
                return !nbt.func_74779_i("name").isEmpty();
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    public ContainerWirelessControllerReactors getGuiContainer(EntityPlayer var1) {
        return new ContainerWirelessControllerReactors(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiWirelessControllerReactors(this.getGuiContainer(var1));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.wireless_controller_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.tileMultiBlockBaseList.clear();
        this.itemStacks.clear();
        for (int i = 0; i < 12; ++i) {
            NBTTagCompound nbt = ModUtils.nbt(this.invslot.get(i));
            BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
            if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((TileMultiBlockBase)tileEntity);
                this.itemStacks.add(((TileMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.field_190927_a);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.tileMultiBlockBaseList.clear();
        for (int i = 0; i < 12; ++i) {
            NBTTagCompound nbt = ModUtils.nbt(this.invslot.get(i));
            BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
            if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((TileMultiBlockBase)tileEntity);
                this.itemStacks.add(((TileMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.field_190927_a);
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        TileMultiBlockBase tileMultiBlockBase;
        if (!this.itemStacks.get((int)var2).func_190926_b() && (tileMultiBlockBase = this.tileMultiBlockBaseList.get((int)var2)) != null && tileMultiBlockBase.isFull() && !tileMultiBlockBase.func_145837_r()) {
            tileMultiBlockBase.onActivated(var1, var1.func_184600_cs(), EnumFacing.NORTH, 0.0f, 0.0f, 0.0f);
        }
    }
}

