/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerWirelessMineralQuarry;
import com.denfop.gui.GuiWirelessMineralQuarry;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemVeinSensor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityWirelessMineralQuarry
extends TileEntityInventory
implements IManufacturerBlock {
    public final Energy energy;
    public final InvSlot invslot;
    public final InvSlotOutput output;
    public List<Vein> veinList = new LinkedList<Vein>();
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public int level;

    public TileEntityWirelessMineralQuarry() {
        this.output = new InvSlotOutput(this, 18);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 50000.0, 14));
        this.invslot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 4){

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                TileEntityWirelessMineralQuarry.this.updateList();
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.func_77973_b() instanceof ItemVeinSensor)) {
                    return false;
                }
                NBTTagCompound nbt = ModUtils.nbt(stack);
                if (!nbt.func_74779_i("type").isEmpty()) {
                    return !nbt.func_74779_i("type").equals("oil") && !nbt.func_74779_i("type").equals("gas");
                }
                return false;
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    public ContainerWirelessMineralQuarry getGuiContainer(EntityPlayer var1) {
        return new ContainerWirelessMineralQuarry(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiWirelessMineralQuarry(this.getGuiContainer(var1));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.wireless_mineral_quarry;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.level = nbtTagCompound.func_74762_e("level");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("level", this.level);
        return nbtTagCompound;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return true;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean active = false;
        for (int i = 0; i < this.veinList.size(); ++i) {
            Vein vein = this.veinList.get(i);
            ItemStack stack = this.itemStacks.get(i);
            if (!(this.energy.getEnergy() >= 10.0) || !vein.isFind() || vein.getCol() < 1) continue;
            int size = Math.min((this.level + 1) * 2, vein.getCol());
            stack.func_190920_e(size);
            int prev = this.output.addExperimental(stack);
            if ((size -= prev) == 0) continue;
            vein.removeCol(size);
            active = true;
            this.energy.useEnergy(10.0);
        }
        this.setActive(active);
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 0) {
            ret.add(new ItemStack((Item)IUItem.upgrade_speed_creation, this.level));
            this.level = 0;
        }
        return ret;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 10 + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        int i;
        super.readContainerPacket(customPacketBuffer);
        this.veinList.clear();
        this.itemStacks.clear();
        int col = customPacketBuffer.readInt();
        for (i = 0; i < col; ++i) {
            try {
                this.veinList.add((Vein)DecoderHandler.decode(customPacketBuffer));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < col; ++i) {
            try {
                this.itemStacks.add((ItemStack)DecoderHandler.decode(customPacketBuffer));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.veinList.size());
        for (Vein vein : this.veinList) {
            try {
                EncoderHandler.encode(customPacketBuffer, vein);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (ItemStack itemStack : this.itemStacks) {
            try {
                EncoderHandler.encode(customPacketBuffer, itemStack);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.updateList();
        }
    }

    public void updateList() {
        this.veinList.clear();
        this.itemStacks.clear();
        for (ItemStack stack : this.invslot.getContents()) {
            int z;
            NBTTagCompound nbt;
            int x;
            ChunkPos chunkPos;
            Vein vein;
            if (stack.func_190926_b() || !(vein = VeinSystem.system.getVein(chunkPos = new ChunkPos((x = (nbt = ModUtils.nbt(stack)).func_74762_e("x")) >> 4, (z = nbt.func_74762_e("z")) >> 4))).isFind() || vein.getType() != Type.VEIN) continue;
            this.veinList.add(vein);
            if (vein.isOldMineral()) {
                this.itemStacks.add(new ItemStack((Block)IUItem.heavyore, 1, vein.getMeta()));
                continue;
            }
            this.itemStacks.add(new ItemStack((Block)IUItem.mineral, 1, vein.getMeta()));
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }
}

