/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerMagnet;
import com.denfop.container.SlotInfo;
import com.denfop.gui.GuiMagnet;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityAntiMagnet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMagnet
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final SlotInfo slot;
    public int energyconsume = 1000;
    public boolean work = true;
    public String player = "";
    public int x = 11;
    public int y = 11;
    public int z = 11;
    List<Chunk> list = Lists.newArrayList();
    private AxisAlignedBB axisalignedbb;

    public TileMagnet() {
        super(100000.0, 14, 24);
        this.slot = new SlotInfo(this, 18, false);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.energyconsume = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.x = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.y = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.z = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.energyconsume);
            EncoderHandler.encode(packet, this.x);
            EncoderHandler.encode(packet, this.y);
            EncoderHandler.encode(packet, this.z);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.magnet.getSoundEvent();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.magnet_work_info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine1.magnet;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            this.player = player.func_70005_c_();
            for (int x = this.field_174879_c.func_177958_n() - this.x; x <= this.field_174879_c.func_177958_n() + this.x; ++x) {
                for (int y = this.field_174879_c.func_177956_o() - this.y; y <= this.field_174879_c.func_177956_o() + this.y; ++y) {
                    for (int z = this.field_174879_c.func_177952_p() - this.z; z <= this.field_174879_c.func_177952_p() + this.z; ++z) {
                        BlockPos pos1 = new BlockPos(x, y, z);
                        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos1);
                        if (tileEntity == null || pos1.equals((Object)this.field_174879_c) || !(tileEntity instanceof TileEntityAntiMagnet)) continue;
                        TileEntityAntiMagnet tile = (TileEntityAntiMagnet)tileEntity;
                        if (tile.player.equals(this.player)) continue;
                        this.work = false;
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.player = nbttagcompound.func_74779_i("player");
        this.work = nbttagcompound.func_74767_n("work");
        this.x = nbttagcompound.func_74762_e("x1");
        this.y = nbttagcompound.func_74762_e("y1");
        this.z = nbttagcompound.func_74762_e("z1");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74778_a("player", this.player);
        nbttagcompound.func_74757_a("work", this.work);
        nbttagcompound.func_74768_a("x1", this.x);
        nbttagcompound.func_74768_a("y1", this.y);
        nbttagcompound.func_74768_a("z1", this.z);
        return nbttagcompound;
    }

    public boolean canInsertOrExtract(ItemStack stack) {
        List<ItemStack> BlackItemStacks = this.slot.getListBlack();
        if (BlackItemStacks.isEmpty()) {
            List<ItemStack> WhiteItemStacks = this.slot.getListWhite();
            if (!WhiteItemStacks.isEmpty()) {
                for (ItemStack stack1 : WhiteItemStacks) {
                    if (!stack1.func_77969_a(stack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (ItemStack stack1 : BlackItemStacks) {
            if (!stack1.func_77969_a(stack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateData();
    }

    public void updateData() {
        this.axisalignedbb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.x), (double)(this.field_174879_c.func_177956_o() - this.y), (double)(this.field_174879_c.func_177952_p() - this.z), (double)(this.field_174879_c.func_177958_n() + this.x), (double)(this.field_174879_c.func_177956_o() + this.y), (double)(this.field_174879_c.func_177952_p() + this.z));
        int j2 = MathHelper.func_76128_c((double)((this.axisalignedbb.field_72340_a - 2.0) / 16.0));
        int k2 = MathHelper.func_76143_f((double)((this.axisalignedbb.field_72336_d + 2.0) / 16.0));
        int l2 = MathHelper.func_76128_c((double)((this.axisalignedbb.field_72339_c - 2.0) / 16.0));
        int i3 = MathHelper.func_76143_f((double)((this.axisalignedbb.field_72334_f + 2.0) / 16.0));
        this.list = Lists.newArrayList();
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                Chunk chunk = this.field_145850_b.func_72964_e(j3, k3);
                if (this.list.contains(chunk)) continue;
                this.list.add(chunk);
            }
        }
    }

    public List<EntityItem> getEntitiesWithinAABB() {
        ArrayList list = Lists.newArrayList();
        this.list.forEach(chunk -> chunk.func_177430_a(EntityItem.class, this.axisalignedbb, list, EntitySelectors.field_180132_d));
        return list;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.work) {
            return;
        }
        boolean ret = false;
        if (this.field_145850_b.field_73011_w.getWorldTime() % 4L == 0L) {
            List<EntityItem> list = this.getEntitiesWithinAABB();
            for (EntityItem item : list) {
                ItemStack stack;
                if (item.field_70128_L || !this.energy.canUseEnergy(this.energyconsume) || !this.outputSlot.canAdd(stack = item.func_92059_d()) || !this.canInsertOrExtract(item.func_92059_d())) continue;
                item.func_70106_y();
                this.initiate(0);
                this.setActive(true);
                this.energy.useEnergy(this.energyconsume);
                this.outputSlot.add(stack);
                ret = true;
            }
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 10L == 0L && !ret && this.getActive()) {
            this.setActive(false);
            this.initiate(2);
        }
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        if (event == 10.0) {
            super.updateTileServer(player, event);
        } else {
            if (event == 0.0) {
                --this.x;
                this.x = Math.max(1, this.x);
            }
            if (event == 1.0) {
                ++this.x;
                this.x = Math.min(11, this.x);
            }
            if (event == 2.0) {
                --this.y;
                this.y = Math.max(1, this.y);
            }
            if (event == 3.0) {
                ++this.y;
                this.y = Math.min(11, this.y);
            }
            if (event == 4.0) {
                --this.z;
                this.z = Math.max(1, this.z);
            }
            if (event == 5.0) {
                ++this.z;
                this.z = Math.min(11, this.z);
            }
            this.updateData();
        }
    }

    @Override
    public int func_70302_i_() {
        return 24;
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMagnet(new ContainerMagnet(entityPlayer, this));
    }

    public ContainerMagnet getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMagnet(entityPlayer, this);
    }
}

