/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerMagnetGenerator;
import com.denfop.gui.GuiMagnetGenerator;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMagnetGenerator
extends TileElectricMachine {
    public int timer = 86400;

    public TileMagnetGenerator() {
        super(0.0, 14, 1);
        this.energy = this.addComponent(Energy.asBasicSource(this, 3456000.0, 14));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.magnet_generator.getSoundEvent();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.magnet_generator.info"));
        super.addInformation(stack, tooltip);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.timer = nbttagcompound.func_74762_e("timer");
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.timer = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.timer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("timer", this.timer);
        return nbttagcompound;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine1.magnet_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        NBTTagCompound nbt;
        super.onPlaced(stack, placer, facing);
        if (!this.func_145831_w().field_72995_K && (nbt = ModUtils.nbt(stack)).func_74767_n("work")) {
            this.timer = nbt.func_74762_e("timer");
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> list = super.getWrenchDrops(player, fortune);
        NBTTagCompound nbt = ModUtils.nbt(list.get(0));
        nbt.func_74768_a("timer", this.timer);
        nbt.func_74757_a("work", true);
        return list;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).func_77969_a(this.getPickBlock(null, null)) && (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self)) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74768_a("timer", this.timer);
            nbt.func_74757_a("work", true);
        }
        return drop;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.timer == 0) {
            if (this.getActive()) {
                this.initiate(2);
                this.setActive(false);
            }
            return;
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
            --this.timer;
        }
        this.energy.addEnergy(2.0);
        if (!this.getActive()) {
            this.setActive(true);
            this.initiate(0);
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 200L == 0L) {
            this.initiate(2);
            this.initiate(0);
        }
    }

    public String getStartSoundFile() {
        return "Machines/magnet_generator.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public ContainerMagnetGenerator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMagnetGenerator(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiMagnetGenerator getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiMagnetGenerator(new ContainerMagnetGenerator(entityPlayer, this));
    }
}

