/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.IPatternStorage;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerPatternStorage;
import com.denfop.gui.GuiPatternStorage;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemCrystalMemory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilePatternStorage
extends TileEntityInventory
implements IUpdatableTileEvent,
IPatternStorage {
    public final InvSlot diskSlot;
    private final List<RecipeInfo> patterns = new ArrayList<RecipeInfo>();
    public int index = 0;
    public int maxIndex;
    public RecipeInfo pattern;
    public double patternUu;
    public double patternEu;

    public TilePatternStorage() {
        this.diskSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT_OUTPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() == IUItem.crystalMemory;
            }
        };
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.pattern_storage_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.readContents(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeContentsAsNbtList(nbt);
        return nbt;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.index = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.maxIndex = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.pattern = (RecipeInfo)DecoderHandler.decode(customPacketBuffer);
            this.patternUu = (Double)DecoderHandler.decode(customPacketBuffer);
            this.patternEu = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.index);
            EncoderHandler.encode(packet, this.maxIndex);
            EncoderHandler.encode(packet, this.pattern);
            EncoderHandler.encode(packet, this.patternUu);
            EncoderHandler.encode(packet, this.patternEu);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (!this.func_145831_w().field_72995_K) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            this.readContents(nbt);
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).func_77969_a(this.getPickBlock(null, null)) && (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self)) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            this.writeContentsAsNbtList(nbt);
        }
        return drop;
    }

    public void readContents(NBTTagCompound nbt) {
        NBTTagList patternList = nbt.func_150295_c("patterns", 10);
        for (int i = 0; i < patternList.func_74745_c(); ++i) {
            NBTTagCompound contentTag = patternList.func_150305_b(i);
            ItemStack Item2 = new ItemStack(contentTag);
            this.addPattern(new RecipeInfo(Item2, Recipes.recipes.getRecipeOutput((String)"replicator", (boolean)false, (ItemStack[])new ItemStack[]{Item2}).getOutput().metadata.func_74769_h("matter")));
        }
        this.refreshInfo();
    }

    private void writeContentsAsNbtList(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (RecipeInfo stack : this.patterns) {
            NBTTagCompound contentTag = new NBTTagCompound();
            stack.getStack().func_77955_b(contentTag);
            list.func_74742_a((NBTBase)contentTag);
        }
        nbt.func_74782_a("patterns", (NBTBase)list);
    }

    @Override
    public ContainerBase<TilePatternStorage> getGuiContainer(EntityPlayer player) {
        return new ContainerPatternStorage(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiPatternStorage(new ContainerPatternStorage(player, this));
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        switch ((int)event) {
            case 0: {
                if (this.patterns.isEmpty()) break;
                this.index = this.index <= 0 ? this.patterns.size() - 1 : --this.index;
                this.refreshInfo();
                break;
            }
            case 1: {
                if (this.patterns.isEmpty()) break;
                this.index = this.index >= this.patterns.size() - 1 ? 0 : ++this.index;
                this.refreshInfo();
                break;
            }
            case 2: {
                ItemStack crystalMemory;
                if (this.index < 0 || this.index >= this.patterns.size() || this.diskSlot.isEmpty() || !((crystalMemory = this.diskSlot.get()).func_77973_b() instanceof ItemCrystalMemory)) break;
                ((ItemCrystalMemory)crystalMemory.func_77973_b()).writecontentsTag(crystalMemory, this.patterns.get(this.index).getStack());
                break;
            }
            case 3: {
                ItemStack record;
                ItemStack crystalMemory;
                if (this.diskSlot.isEmpty() || !((crystalMemory = this.diskSlot.get()).func_77973_b() instanceof ItemCrystalMemory) || (record = ((ItemCrystalMemory)crystalMemory.func_77973_b()).readItemStack(crystalMemory)) == null) break;
                this.addPattern(new RecipeInfo(record, Recipes.recipes.getRecipeOutput((String)"replicator", (boolean)false, (ItemStack[])new ItemStack[]{record}).getOutput().metadata.func_74769_h("matter")));
            }
        }
    }

    public void refreshInfo() {
        if (this.index < 0 || this.index >= this.patterns.size()) {
            this.index = 0;
        }
        this.maxIndex = this.patterns.size();
        if (this.patterns.isEmpty()) {
            this.pattern = null;
        } else {
            this.pattern = this.patterns.get(this.index);
            this.patternUu = this.pattern.getCol();
            this.patternEu = this.patternUu * 1.0E9;
        }
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean addPattern(RecipeInfo stack) {
        RecipeInfo pattern;
        if (ModUtils.isEmpty(stack.getStack())) {
            throw new IllegalArgumentException("empty stack: " + stack.getStack());
        }
        Iterator<RecipeInfo> var2 = this.patterns.iterator();
        do {
            if (var2.hasNext()) continue;
            this.patterns.add(stack);
            this.refreshInfo();
            return true;
        } while (!ModUtils.checkItemEquality((pattern = var2.next()).getStack(), stack.getStack()));
        return false;
    }

    @Override
    public List<RecipeInfo> getPatterns() {
        return this.patterns;
    }
}

