/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerPlasticPlateCreator;
import com.denfop.gui.GuiPlasticPlateCreator;
import com.denfop.invslot.InvSlot;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileBasePlasticPlateCreator;
import com.denfop.utils.ModUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilePlasticPlateCreator
extends TileBasePlasticPlateCreator
implements IUpdateTick,
IHasRecipe {
    public final InvSlot input_slot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public TilePlasticPlateCreator() {
        super(1, 300, 1);
        this.inputSlotA = new InvSlotRecipes(this, "plasticplate", this, this.fluidTank);
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.INPUT);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.inputSlotA.setInvSlotConsumableLiquidByList(this.fluidSlot);
        Recipes.recipes.addInitRecipes(this);
        this.input_slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (this.get().func_190926_b()) {
                    ((TilePlasticPlateCreator)this.base).inputSlotA.changeAccepts(ItemStack.field_190927_a);
                } else {
                    ((TilePlasticPlateCreator)this.base).inputSlotA.changeAccepts(this.get());
                }
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() == IUItem.recipe_schedule;
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            if (this.input_slot.isEmpty()) {
                this.inputSlotA.changeAccepts(ItemStack.field_190927_a);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get());
            }
        }
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidoxy.getInstance(), 1000), input.getInput(new ItemStack(IUItem.plast))), new RecipeOutput(null, new ItemStack(IUItem.plastic_plate))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidglucose.getInstance(), 200), input.getInput(Items.field_151114_aO)), new RecipeOutput(null, new ItemStack(Items.field_151102_aT, 2))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidco2.getInstance(), 500), input.getInput(new ItemStack(Items.field_151145_ak, 4))), new RecipeOutput(null, new ItemStack((Item)IUItem.crafting_elements, 1, 344))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidRegistry.WATER, 500), input.getInput(new ItemStack((Item)IUItem.iudust, 2, 66))), new RecipeOutput(null, new ItemStack((Item)IUItem.raw_apatite))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidRegistry.WATER, 500), input.getInput(new ItemStack(Blocks.field_150346_d))), new RecipeOutput(null, new ItemStack(Blocks.field_150435_aG))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidoxy.getInstance(), 200), input.getInput(new ItemStack((Item)IUItem.red_phosphorus, 4))), new RecipeOutput(null, new ItemStack((Item)IUItem.phosphorus_oxide, 2))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidglowstone.getInstance(), 125), input.getInput(new ItemStack((Item)IUItem.iudust, 1, 75))), new RecipeOutput(null, new ItemStack(Items.field_151079_bi))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidglowstone.getInstance(), 125), input.getInput(new ItemStack((Item)IUItem.iudust, 1, 77))), new RecipeOutput(null, new ItemStack(Items.field_151073_bk))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidchlorum.getInstance(), 180), input.getInput(new ItemStack((Item)IUItem.iudust, 2, 26))), new RecipeOutput(null, new ItemStack((Item)IUItem.iudust, 1, 79))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidorthophosphoricacid.getInstance(), 100), input.getInput(new ItemStack((Item)IUItem.iudust, 1, 37))), new RecipeOutput(null, new ItemStack((Item)IUItem.iudust, 1, 70))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidorthophosphoricacid.getInstance(), 100), input.getInput(new ItemStack((Item)IUItem.iudust, 1, 64))), new RecipeOutput(null, new ItemStack((Item)IUItem.iudust, 1, 69))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidbutadiene_nitrile.getInstance(), 100), input.getInput(ModUtils.setSize(IUItem.rubber, 1))), new RecipeOutput(null, new ItemStack((Item)IUItem.synthetic_rubber, 4))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidroyaljelly.getInstance(), 200), input.getInput(Items.field_151015_O)), new RecipeOutput(null, new ItemStack((Item)IUItem.royal_jelly))));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.plastic_plate_creator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockPlasticPlateCreator.name");
    }

    @Override
    public int gaugeLiquidScaled(int i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0 : this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
    }

    public ContainerPlasticPlateCreator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPlasticPlateCreator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPlasticPlateCreator(new ContainerPlasticPlateCreator(entityPlayer, this));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.plastic_plate.getSoundEvent();
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract});
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

