/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerSolidCoolMachine;
import com.denfop.gui.GuiSolidCoolMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileSolidCooling
extends TileElectricMachine
implements IUpdatableTileEvent {
    public static boolean init = false;
    static Map<ItemStack, Integer> timerItem = new HashMap<ItemStack, Integer>();
    public final InvSlot slot;
    public int time;
    public CoolComponent cold = this.addComponent(CoolComponent.asBasicSource(this, 4.0, 14));
    public int max = 4;
    public boolean work;

    public TileSolidCooling() {
        super(0.0, 0, 1);
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.REFRIGERATOR);
        this.time = 0;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                boolean find = false;
                for (Map.Entry<ItemStack, Integer> entry : timerItem.entrySet()) {
                    if (!entry.getKey().func_77969_a(stack)) continue;
                    find = true;
                    break;
                }
                return find;
            }
        };
    }

    public static void init() {
        timerItem.put(new ItemStack(Items.field_151126_ay, 1), 2);
        timerItem.put(new ItemStack(Blocks.field_150433_aE, 1), 10);
        timerItem.put(new ItemStack(Blocks.field_150432_aD, 1), 30);
        timerItem.put(new ItemStack(Blocks.field_150403_cj, 1), 90);
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.max = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.time = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.max);
            EncoderHandler.encode(packet, this.work);
            EncoderHandler.encode(packet, this.time);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.solid_cooling;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.max = nbttagcompound.func_74762_e("max");
        this.work = nbttagcompound.func_74767_n("work");
        this.cold.setCapacity(this.max);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("max", this.max);
        nbttagcompound.func_74757_a("work", this.work);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i == 0.0) {
            this.cold.setCapacity(this.max + 4);
            if (this.cold.getCapacity() > 16.0) {
                this.cold.setCapacity(16.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 1.0) {
            this.cold.setCapacity(this.max - 4);
            if (this.cold.getCapacity() < 4.0) {
                this.cold.setCapacity(4.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 2.0) {
            boolean bl = this.work = !this.work;
        }
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        tooltip.add(Localization.translate("iu.solid_colling"));
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.time == 0 && !this.slot.isEmpty()) {
            for (Map.Entry<ItemStack, Integer> entry : timerItem.entrySet()) {
                if (!entry.getKey().func_77969_a(this.slot.get())) continue;
                this.time = entry.getValue();
                this.slot.get(0).func_190918_g(1);
                break;
            }
        }
        if ((this.cold.allow || this.work) && this.time > 0) {
            if (this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                --this.time;
                this.initiate(0);
                this.setActive(true);
            }
            if (this.field_145850_b.field_73011_w.getWorldTime() % 400L == 0L) {
                this.initiate(2);
            }
            if (this.time == 0) {
                this.initiate(2);
                this.setActive(false);
            } else {
                this.initiate(0);
            }
        } else {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L && this.cold.getEnergy() >= 1.0) {
            this.cold.addEnergy(-1.0);
        }
    }

    public ContainerSolidCoolMachine getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolidCoolMachine(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiSolidCoolMachine(this.getGuiContainer(entityPlayer));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.cooling.getSoundEvent();
    }
}

