/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.blastfurnace.block;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBlastFurnace;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBlastFurnace;
import com.denfop.effects.SmokeParticle;
import com.denfop.effects.SparkParticle;
import com.denfop.gui.GuiBlastFurnace;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.items.resource.ItemIngots;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.render.oilquarry.DataBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.blastfurnace.api.IBlastHeat;
import com.denfop.tiles.mechanism.blastfurnace.api.IBlastInputFluid;
import com.denfop.tiles.mechanism.blastfurnace.api.IBlastMain;
import com.denfop.tiles.mechanism.blastfurnace.api.InvSlotBlastFurnace;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleLava;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileBlastFurnaceMain
extends TileMultiBlockBase
implements IBlastMain,
IUpdatableTileEvent,
IAudioFixer {
    public final FluidTank tank;
    public final InvSlotOutput output1;
    public final InvSlotFluidByList fluidSlot;
    public final HeatComponent heat;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public boolean load = false;
    public ItemStack outputStack = ItemStack.field_190927_a;
    public InvSlotBlastFurnace invSlotBlastFurnace = new InvSlotBlastFurnace(this);
    public InvSlotOutput output = new InvSlotOutput(this, 1);
    public FluidTank tank1 = new FluidTank(12000);
    public IBlastHeat blastHeat;
    public IBlastInputFluid blastInputFluid;
    public List<EntityPlayer> entityPlayerList;
    public double progress = 0.0;
    public int bar = 1;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound = true;
    @SideOnly(value=Side.CLIENT)
    private DataBlock dataBlock;
    @SideOnly(value=Side.CLIENT)
    private DataBlock dataBlock_active;

    public TileBlastFurnaceMain() {
        super(InitMultiBlockSystem.blastFurnaceMultiBlock);
        this.full = false;
        Fluids fluids = this.addComponent(new Fluids(this));
        this.tank = fluids.addTank("tank", 10000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(FluidName.fluidsteam.getInstance()));
        this.entityPlayerList = new ArrayList<EntityPlayer>();
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, 1, FluidRegistry.WATER);
        this.output1 = new InvSlotOutput(this, 1);
        this.heat = this.addComponent(HeatComponent.asBasicSink(this, 1000.0));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.2));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.5));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive() && this.func_145831_w().func_72820_D() % 5L == 0L) {
            Random rand = WorldBaseGen.random;
            EnumFacing facing = this.getFacing();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    double offsetX = 0.0;
                    double offsetZ = 0.0;
                    switch (facing) {
                        case NORTH: {
                            offsetZ = -0.3;
                            break;
                        }
                        case SOUTH: {
                            offsetZ = 0.3;
                            break;
                        }
                        case WEST: {
                            offsetX = -0.3;
                            break;
                        }
                        case EAST: {
                            offsetX = 0.3;
                            break;
                        }
                    }
                    int sparkCount = 1 + rand.nextInt(2);
                    for (int i = 0; i < sparkCount; ++i) {
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new SparkParticle(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5 + (double)dx + offsetX * -1.0 + rand.nextDouble() * 0.2 - 0.1, (double)this.func_174877_v().func_177956_o() + 1.2 + rand.nextDouble() * 0.2, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)dz + offsetZ * -1.0 + rand.nextDouble() * 0.2 - 0.1));
                    }
                    int smokeCount = 1 + rand.nextInt(2);
                    for (int j = 0; j < smokeCount; ++j) {
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new SmokeParticle(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5 + (double)dx + offsetX * -1.0 + rand.nextDouble() * 0.3 - 0.15, (double)this.func_174877_v().func_177956_o() + 1.5 + rand.nextDouble() * 0.2, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)dz + offsetZ * -1.0 + rand.nextDouble() * 0.3 - 0.15));
                    }
                    if (rand.nextInt(3) == 0) {
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(new ParticleFlame.Factory().func_178902_a(0, this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5 + (double)dx + offsetX * -1.0 + rand.nextDouble() * 0.2 - 0.1, (double)this.func_174877_v().func_177956_o() + 1.3 + rand.nextDouble() * 0.3, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)dz + offsetZ * -1.0 + rand.nextDouble() * 0.2 - 0.1, 0.0, 0.05, 0.0, new int[0]));
                    }
                    if (rand.nextInt(3) == 0) {
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(new ParticleRedstone.Factory().func_178902_a(0, this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5 + (double)dx + offsetX * -1.0 + rand.nextDouble() * 0.4 - 0.2, (double)this.func_174877_v().func_177956_o() + 1.4 + rand.nextDouble() * 0.3, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)dz + offsetZ * -1.0 + rand.nextDouble() * 0.4 - 0.2, 1.0, (double)0.3f, (double)0.1f, new int[0]));
                    }
                    if (rand.nextInt(5) != 0) continue;
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(Objects.requireNonNull(new ParticleLava.Factory().func_178902_a(0, this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5 + (double)dx + offsetX * -4.0 + rand.nextDouble() * 0.4 - 0.2, (double)this.func_174877_v().func_177956_o() + 1.6, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)dz + offsetZ * -4.0 + rand.nextDouble() * 0.4 - 0.2, 0.0, 0.1, 0.0, new int[0])));
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUniqueMultiBlock() {
        IBlockState state;
        IBakedModel model;
        if (this.dataBlock.getBlockState().func_177230_c() == IUItem.invalid) {
            return;
        }
        IBakedModel model2 = this.dataBlock.getState();
        Class<?> clazz1 = null;
        for (Class<?> clazz = model2.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().equals("net.minecraftforge.client.model.FancyMissingModel$BakedModel")) continue;
            clazz1 = clazz;
            break;
        }
        if (clazz1 != null) {
            IBlockState blockState1 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, "global")).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
            this.dataBlock = new DataBlock(blockState1);
            IBakedModel model3 = Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockState1);
            this.dataBlock.setState(model3);
            blockState1 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, "global_active")).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
            this.dataBlock_active = new DataBlock(blockState1);
            model3 = Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockState1);
            this.dataBlock_active.setState(model3);
        }
        GlStateManager.func_179121_F();
        switch (this.facing) {
            case 2: {
                GlStateManager.func_179137_b((double)((double)this.field_174879_c.func_177958_n() - 1.05), (double)(this.field_174879_c.func_177956_o() - 1), (double)((double)this.field_174879_c.func_177952_p() - 0.05));
                break;
            }
            case 3: {
                GlStateManager.func_179137_b((double)((double)this.field_174879_c.func_177958_n() - 1.05), (double)((double)this.field_174879_c.func_177956_o() - 1.05), (double)((double)this.field_174879_c.func_177952_p() - 2.05));
                break;
            }
            case 4: {
                GlStateManager.func_179137_b((double)((double)this.field_174879_c.func_177958_n() - 0.05), (double)((double)this.field_174879_c.func_177956_o() - 1.05), (double)(this.field_174879_c.func_177952_p() - 1));
                break;
            }
            case 5: {
                GlStateManager.func_179137_b((double)((double)this.field_174879_c.func_177958_n() - 2.05), (double)((double)this.field_174879_c.func_177956_o() - 1.05), (double)((double)this.field_174879_c.func_177952_p() - 1.05));
            }
        }
        GlStateManager.func_179139_a((double)3.08, (double)3.08, (double)3.08);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.getActive()) {
            model = this.dataBlock.getState();
            state = this.dataBlock.getBlockState();
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.render(model, state, enumfacing);
            }
            this.render(model, state, null);
        } else {
            model = this.dataBlock_active.getState();
            state = this.dataBlock_active.getBlockState();
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.render(model, state, enumfacing);
            }
            this.render(model, state, null);
        }
        GlStateManager.func_179094_E();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBlastFurnace.blast_furnace_main;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blastfurnace;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.full = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.tank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.bar = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.heat.storage = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.full);
            EncoderHandler.encode(packet, this.tank1);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.bar);
            EncoderHandler.encode(packet, this.sound);
            EncoderHandler.encode(packet, this.heat.storage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.blastfurnace.info1"));
        tooltip.add(Localization.translate("iu.blastfurnace.info3") + Localization.translate(new ItemStack((Block)IUItem.blastfurnace, 1, 0).func_77977_a()));
        tooltip.add(Localization.translate("iu.blastfurnace.info4"));
        tooltip.add(Localization.translate("iu.blastfurnace.info5") + new ItemStack((Item)IUItem.ForgeHammer).func_82833_r());
        tooltip.add(Localization.translate("iu.blastfurnace.info6"));
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.blast_furnace.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.InterruptOne.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IBlastInputFluid.class);
        this.setInputFluid((IBlastInputFluid)this.func_145831_w().func_175625_s(pos1.get(0)));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IBlastHeat.class);
        this.setHeat((IBlastHeat)this.func_145831_w().func_175625_s(pos1.get(0)));
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "sound", this.sound);
            if (this.invSlotBlastFurnace.isEmpty()) {
                this.outputStack = ItemStack.field_190927_a;
            } else {
                ItemStack content = this.invSlotBlastFurnace.get();
                int meta = content.func_77952_i();
                this.outputStack = content.func_77973_b().equals(Items.field_151042_j) ? IUItem.advIronIngot : (content.func_77973_b() instanceof ItemIngots && meta == 3 ? new ItemStack((Item)IUItem.crafting_elements, 1, 480) : new ItemStack((Item)IUItem.crafting_elements, 1, 479));
            }
        } else {
            IBlockState blockState1 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, "global")).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
            this.dataBlock = new DataBlock(blockState1);
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockState1);
            this.dataBlock.setState(model);
            IBlockState blockState2 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, "global_active")).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
            this.dataBlock_active = new DataBlock(blockState2);
            IBakedModel model1 = Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockState2);
            this.dataBlock_active.setState(model1);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.full) {
            if (this.getActive()) {
                this.setActive(false);
                this.initiate(2);
            }
            return;
        }
        MutableObject output1 = new MutableObject();
        if (this.fluidSlot.transferToTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.output1.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot.transferToTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.output1.add((ItemStack)output1.getValue());
            }
        }
        if (!this.invSlotBlastFurnace.isEmpty() && !this.outputStack.func_190926_b() && this.output.canAdd(this.outputStack)) {
            double heat;
            int amount_stream = this.tank.getFluidAmount();
            if (this.heat.getEnergy() == this.heat.getCapacity()) {
                int bar1 = this.bar;
                if (amount_stream < bar1 * 2) {
                    bar1 = amount_stream / 2;
                }
                if (bar1 > 0) {
                    if (this.progress == 0.0) {
                        this.setActive(true);
                        this.initiate(0);
                    }
                    if (!this.getActive()) {
                        this.setActive(true);
                    }
                    this.progress += 1.0 + 0.25 * (double)(bar1 - 1);
                    this.tank.drain(Math.min(bar1 * 2, this.tank.getFluidAmount()), true);
                    if (this.progress >= 3600.0 && this.output.add(this.outputStack)) {
                        this.progress = 0.0;
                        this.invSlotBlastFurnace.get(0).func_190918_g(1);
                        this.setActive(false);
                        this.initiate(2);
                    }
                }
            }
            if ((heat = this.heat.getEnergy()) > 500.0 && this.tank.getFluidAmount() + 2 < this.tank.getCapacity()) {
                int add;
                int size = this.tank1.getFluidAmount();
                int size_stream = this.tank.getCapacity() - this.tank.getFluidAmount();
                int size1 = size / 5;
                if ((size1 = Math.min(size1, 10)) > 0 && (add = Math.min(size_stream / 2, size1)) > 0) {
                    this.tank.fill(new FluidStack(FluidName.fluidsteam.getInstance(), add * 2), true);
                    this.getInputFluid().getFluidTank().drain(add * 5, true);
                }
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.heat.getEnergy() > 0.0) {
            this.heat.useEnergy(1.0);
        }
    }

    @Override
    public IBlastHeat getHeat() {
        return this.blastHeat;
    }

    @Override
    public void setHeat(IBlastHeat blastHeat) {
        this.blastHeat = blastHeat;
        try {
            this.heat.onUnloaded();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.blastHeat != null) {
            this.heat.setParent((TileEntityInventory)((Object)blastHeat));
            this.heat.onLoaded();
        }
    }

    @Override
    public IBlastInputFluid getInputFluid() {
        return this.blastInputFluid;
    }

    @Override
    public void setInputFluid(IBlastInputFluid blastInputFluid) {
        this.blastInputFluid = blastInputFluid;
        if (this.blastInputFluid == null) {
            this.tank1 = new FluidTank(12000);
            new PacketUpdateFieldTile(this, "fluidtank1", false);
        } else {
            this.tank1 = this.blastInputFluid.getFluidTank();
            new PacketUpdateFieldTile(this, "fluidtank2", this.tank1);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.sound = nbttagcompound.func_74767_n("sound");
        this.bar = nbttagcompound.func_74762_e("bar");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("sound", this.sound);
        nbttagcompound.func_74768_a("bar", this.bar);
        return nbttagcompound;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        switch ((int)i) {
            case 0: {
                this.bar = Math.min(this.bar + 1, 5);
                break;
            }
            case 1: {
                this.bar = Math.max(1, this.bar - 1);
                break;
            }
            case 10: {
                this.sound = !this.sound;
                new PacketUpdateFieldTile(this, "sound", this.sound);
                if (this.sound || this.getTypeAudio() != EnumTypeAudio.ON) break;
                this.setType(EnumTypeAudio.OFF);
                this.initiate(2);
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.full && this.activate) {
            if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.blastInputFluid.getFluid().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
            }
            return super.onActivated(player, hand, side, hitX, hitY, hitZ);
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    public ContainerBlastFurnace getGuiContainer(EntityPlayer entityPlayer) {
        if (!this.entityPlayerList.contains(entityPlayer)) {
            this.entityPlayerList.add(entityPlayer);
        }
        return new ContainerBlastFurnace(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiBlastFurnace getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiBlastFurnace(this.getGuiContainer(entityPlayer));
    }

    @Override
    public IMainMultiBlock getMain() {
        return this;
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public void onNetworkEvent(int var1) {
    }
}

