/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.combpump;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerCombPump;
import com.denfop.gui.GuiCompPump;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.tiles.mechanism.combpump.EnumTypePump;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;
import org.lwjgl.input.Keyboard;

public class TileEntityCombinedPump
extends TileElectricLiquidTankInventory
implements IUpgradableBlock,
IType {
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final InvSlotFluid containerSlot = new InvSlotFluid(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT);
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final ComponentBaseEnergy energyQe;
    public final EnumTypePump typePump;
    public double energyConsume;
    public int operationsPerTick;
    public short progress = 0;
    public int operationLength;
    public float guiProgress;
    public int x;
    public int z;
    public int y;
    boolean canWork = true;

    public TileEntityCombinedPump(int size, int operationLength, EnumTypePump typePump) {
        super(0.0, 0, size);
        this.typePump = typePump;
        this.energyQe = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 100.0));
        this.outputSlot = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.defaultEnergyConsume = this.energyConsume = (double)(this.getStyle().ordinal() + 1);
        this.defaultOperationLength = this.operationLength = operationLength;
        this.defaultTier = 1;
        this.defaultEnergyStorage = this.operationLength;
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.x = customPacketBuffer.readInt();
            this.y = customPacketBuffer.readInt();
            this.z = customPacketBuffer.readInt();
            this.canWork = customPacketBuffer.readBoolean();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ContainerCombPump getGuiContainer(EntityPlayer var1) {
        return new ContainerCombPump(var1, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiCompPump(this.getGuiContainer(var1));
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, Float.valueOf(this.guiProgress));
            packet.writeInt(this.x);
            packet.writeInt(this.y);
            packet.writeInt(this.z);
            packet.writeBoolean(this.canWork);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (this.canWork && this.energyQe.canUseEnergy(this.energyConsume)) {
            if (this.progress < this.operationLength) {
                this.progress = (short)(this.progress + 1);
                this.energyQe.useEnergy(this.energyConsume);
            } else {
                for (int i = 0; i < this.operationsPerTick; ++i) {
                    if (this.x < this.func_174877_v().func_177958_n() + this.typePump.getXz()) {
                        ++this.x;
                    } else if (this.z < this.func_174877_v().func_177952_p() + this.typePump.getXz()) {
                        ++this.z;
                        this.x = this.func_174877_v().func_177958_n();
                    } else if (this.y >= this.func_174877_v().func_177956_o() - this.typePump.getY()) {
                        this.z = this.func_174877_v().func_177952_p();
                        this.x = this.func_174877_v().func_177958_n();
                        --this.y;
                    } else {
                        this.canWork = false;
                    }
                    if (!this.operate(this.x, this.y, this.z)) continue;
                    this.progress = 0;
                }
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        this.guiProgress = (float)this.progress / (float)this.operationLength;
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean operate(int x, int y, int z) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        FluidStack liquid = this.pump(new BlockPos(x, y, z), false);
        if (this.getFluidTank().fill(liquid, false) > 0) {
            this.getFluidTank().fill(liquid, true);
            canOperate = true;
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        IBlockState block;
        FluidStack ret = null;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.func_145831_w().func_180495_p(pos)).func_185904_a().func_76224_d()) {
            if (block.func_177230_c() instanceof IFluidBlock) {
                IFluidBlock liquid = (IFluidBlock)block.func_177230_c();
                if ((this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == liquid.getFluid()) && liquid.canDrain(this.func_145831_w(), pos)) {
                    if (!sim) {
                        ret = liquid.drain(this.func_145831_w(), pos, true);
                        this.func_145831_w().func_175698_g(pos);
                    } else {
                        ret = new FluidStack(liquid.getFluid(), 1000);
                    }
                }
            } else {
                if (block.func_177230_c().func_176201_c(block) != 0) {
                    return null;
                }
                ret = new FluidStack(FluidRegistry.getFluid((String)block.func_177230_c().func_149739_a().substring(5)), 1000);
                if (!(this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != ret.getFluid() || sim)) {
                    this.func_145831_w().func_175698_g(pos);
                }
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
            this.x = this.field_174879_c.func_177958_n();
            this.y = this.field_174879_c.func_177956_o() - 1;
            this.z = this.field_174879_c.func_177952_p();
        }
    }

    public void setUpgradestat() {
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = ((double)this.defaultOperationLength + (double)this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityCombinedPump.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, 1.0);
        this.energyQe.setSinkTier(TileEntityCombinedPump.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.energyQe.setCapacity(TileEntityCombinedPump.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + (double)this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public double getEnergy() {
        return this.energyQe.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energyQe.canUseEnergy(amount)) {
            this.energyQe.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.x = nbttagcompound.func_74762_e("x_pump");
        this.y = nbttagcompound.func_74762_e("y_pump");
        this.z = nbttagcompound.func_74762_e("z_pump");
        this.canWork = nbttagcompound.func_74767_n("canWork");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        nbttagcompound.func_74768_a("x_pump", this.x);
        nbttagcompound.func_74768_a("y_pump", this.y);
        nbttagcompound.func_74768_a("z_pump", this.z);
        nbttagcompound.func_74757_a("canWork", this.canWork);
        return nbttagcompound;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return null;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

