/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.cooling;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerFluidCoolMachine;
import com.denfop.gui.GuiFluidCoolMachine;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;
import org.lwjgl.input.Keyboard;

public class TileFluidCooling
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final Fluids.InternalFluidTank tank;
    public final InvSlotFluidByList fluidSlot1;
    private final Fluids fluid;
    public CoolComponent cold = this.addComponent(CoolComponent.asBasicSource(this, 4.0, 14));
    public int max = 4;
    public boolean work;

    public TileFluidCooling() {
        super(0.0, 0, 1);
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.REFRIGERATOR);
        this.fluid = this.addComponent(new Fluids(this));
        this.tank = this.fluid.addTankInsert("insert", 5000, Fluids.fluidPredicate(FluidName.fluidazot.getInstance(), FluidName.fluidhyd.getInstance(), FluidName.fluidHelium.getInstance()));
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, Arrays.asList(FluidName.fluidazot.getInstance(), FluidName.fluidhyd.getInstance(), FluidName.fluidHelium.getInstance()));
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.max = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.max);
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.fluid_cooling;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.max = nbttagcompound.func_74762_e("max");
        this.work = nbttagcompound.func_74767_n("work");
        this.cold.setCapacity(this.max);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("max", this.max);
        nbttagcompound.func_74757_a("work", this.work);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i == 0.0) {
            this.cold.setCapacity(this.max + 4);
            if (this.cold.getCapacity() > 16.0) {
                this.cold.setCapacity(16.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 1.0) {
            this.cold.setCapacity(this.max - 4);
            if (this.cold.getCapacity() < 4.0) {
                this.cold.setCapacity(4.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 2.0) {
            boolean bl = this.work = !this.work;
        }
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        tooltip.add(Localization.translate("iu.fluid_colling"));
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        int coef = 1;
        FluidStack fluidStack = this.tank.getFluid();
        int time = 20;
        if (fluidStack != null) {
            if (fluidStack.getFluid() == FluidName.fluidhyd.getInstance()) {
                coef = this.max / 4;
            } else if (fluidStack.getFluid() == FluidName.fluidazot.getInstance()) {
                coef = this.max / 8 + 1;
                time = 40;
            } else {
                time = 60;
            }
        }
        MutableObject output1 = new MutableObject();
        if (this.tank.getCapacity() - this.tank.getFluidAmount() >= 1000 && this.fluidSlot1.transferToTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferToTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (this.cold.allow || this.work) {
            if (this.tank.getFluidAmount() >= coef && this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                this.tank.drain(coef, true);
                this.initiate(0);
                this.setActive(true);
            }
            if (this.field_145850_b.field_73011_w.getWorldTime() % 400L == 0L) {
                this.initiate(2);
            }
            if (this.tank.getFluidAmount() < coef) {
                this.initiate(2);
                this.setActive(false);
            } else {
                this.initiate(0);
            }
        } else {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % (long)time == 0L && this.cold.getEnergy() >= 1.0) {
            this.cold.addEnergy(-1.0);
        }
    }

    public ContainerFluidCoolMachine getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerFluidCoolMachine(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiFluidCoolMachine(this.getGuiContainer(entityPlayer));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.cooling.getSoundEvent();
    }
}

