/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyController;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EventLoadController;
import com.denfop.api.energy.event.EventUnloadController;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerRemover;
import com.denfop.gui.GuiEnergyRemover;
import com.denfop.invslot.InvSlot;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.world.WorldBaseGen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergyRemover
extends TileEntityInventory
implements IUpdatableTileEvent,
IEnergyController {
    public final InvSlot slot;
    public Set<IEnergyConductor> conductorList = new HashSet<IEnergyConductor>();
    FakePlayerSpawner fakePlayer;
    Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    int hashCodeSource;
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    private boolean work;
    private long id;

    public TileEnergyRemover() {
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.OUTPUT, 16);
        this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 0.0, 14));
    }

    @Override
    public void RemoveTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public void AddTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.func_176734_d()));
        }
    }

    @Override
    public Map<EnumFacing, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.energy_remover;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadController(this));
            this.fakePlayer = new FakePlayerSpawner(this.func_145831_w());
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void onUnloaded() {
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnloadController(this));
        }
        super.onUnloaded();
    }

    public ContainerRemover getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerRemover(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiEnergyRemover(this.getGuiContainer(entityPlayer));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("work", this.work);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.work = nbtTagCompound.func_74767_n("work");
    }

    public void discover() {
        this.conductorList.clear();
        LinkedList<Energy.EnergyNetDelegate> tileEntitiesToCheck = new LinkedList<Energy.EnergyNetDelegate>();
        LinkedList<IEnergyConductor> reachedTileEntities = new LinkedList<IEnergyConductor>();
        Energy.EnergyNetDelegate tile = this.getComp(Energy.class).delegate;
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        while (!tileEntitiesToCheck.isEmpty()) {
            IEnergyTile currentTileEntity = (IEnergyTile)tileEntitiesToCheck.pop();
            List<InfoTile<IEnergyTile>> validReceivers = currentTileEntity.getValidReceivers();
            for (InfoTile<IEnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((IEnergyTile)validReceiver.tileEntity).getIdNetwork() == id || !(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                ((IEnergyTile)validReceiver.tileEntity).setId(id);
                tileEntitiesToCheck.push((Energy.EnergyNetDelegate)validReceiver.tileEntity);
                reachedTileEntities.add((IEnergyConductor)validReceiver.tileEntity);
            }
        }
        this.conductorList.addAll(reachedTileEntities);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            for (IEnergyConductor conductor : this.conductorList) {
                TileEntityBlock tile = (TileEntityBlock)EnergyNetGlobal.instance.getBlockPosFromEnergyTile(conductor);
                tile.onUnloaded();
                List<ItemStack> drops = tile.getBlockType().getDrops((IBlockAccess)this.field_145850_b, tile.func_174877_v(), tile.getBlockState(), 100);
                if (!this.slot.add(drops.get(0))) continue;
                conductor.removeConductor();
            }
            this.work = false;
            this.discover();
        }
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (i == 0.0) {
            this.discover();
        } else if (i == 1.0) {
            this.work = true;
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.discover();
        }
    }

    @Override
    public void unload() {
        this.conductorList.clear();
    }
}

