/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.exp;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockResource;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.container.ContainerStorageExp;
import com.denfop.gui.GuiStorageExp;
import com.denfop.invslot.InvSlotExpStorage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileStorageExp
extends TileEntityInventory
implements IUpdatableTileEvent,
IAudioFixer {
    public final InvSlotExpStorage inputSlot;
    public final ComponentBaseEnergy energy;
    public int expirencelevel;
    public int expirencelevel1;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private double energy1;
    private boolean sound = true;

    public TileStorageExp() {
        this.inputSlot = new InvSlotExpStorage(this);
        this.energy = this.addComponent(new ComponentBaseEnergy(EnergyType.EXPERIENCE, this, 4.0E9, ModUtils.allFacings, ModUtils.allFacings, 14));
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.sound = nbttagcompound.func_74767_n("sound");
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.expirencelevel = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.expirencelevel1 = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.expirencelevel);
            EncoderHandler.encode(packet, this.expirencelevel1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.expierence_block;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        double energy1 = nbt.func_74769_h("energy");
        if (energy1 != 0.0) {
            tooltip.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(energy1) + "/" + ModUtils.getString(this.energy.getCapacity()) + " EXP");
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    ComponentBaseEnergy component2 = this.energy;
                    if (component2 != null && component2.getEnergy() != 0.0) {
                        NBTTagCompound nbt = ModUtils.nbt(drop);
                        nbt.func_74780_a("energy", component2.getEnergy());
                    }
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack((Block)IUItem.basemachine2, 1, 78);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        ComponentBaseEnergy component2 = this.energy;
        if (component2 != null && component2.getEnergy() != 0.0) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74780_a("energy", component2.getEnergy());
        }
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        double energy1 = nbt.func_74769_h("energy");
        if (energy1 != 0.0) {
            this.energy.addEnergy(energy1);
        }
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    public String getStartSoundFile() {
        return "Machines/zab.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/zap.ogg";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiStorageExp(new ContainerStorageExp(entityPlayer, this));
    }

    public ContainerStorageExp getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerStorageExp(entityPlayer, this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy1 != this.energy.getEnergy()) {
            this.expirencelevel = ExperienceUtils.getLevelForExperience((int)Math.min(this.energy.getEnergy(), 2.0E9));
            this.expirencelevel1 = ExperienceUtils.getLevelForExperience((int)Math.min(Math.min(this.energy.getEnergy() - 2.0E9, 0.0), 2.0E9));
            this.energy1 = this.energy.getEnergy();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.zab.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.expirencelevel = ExperienceUtils.getLevelForExperience((int)Math.min(this.energy.getEnergy(), 2.0E9));
        this.expirencelevel1 = ExperienceUtils.getLevelForExperience((int)Math.min(Math.min(this.energy.getEnergy() - 2.0E9, 0.0), 2.0E9));
        this.energy1 = this.energy.getEnergy();
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.zap.getSoundEvent();
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        if (event == 1.0 && this.energy.getEnergy() < this.energy.getCapacity()) {
            this.energy.storage = ExperienceUtils.removePlayerXP(player, this.energy.getCapacity(), this.energy.getEnergy());
            this.initiate(1);
        }
        if (event == 0.0 && this.energy.getEnergy() > 0.0) {
            int temp = 0;
            if (this.energy.getEnergy() > 2.0E9) {
                temp = (int)(this.energy.getEnergy() - 2.0E9);
            }
            this.energy.storage = ExperienceUtils.addPlayerXP1(player, (int)Math.min(this.energy.getEnergy(), 2.0E9));
            this.energy.addEnergy(temp);
            this.initiate(0);
        }
        this.expirencelevel = ExperienceUtils.getLevelForExperience((int)Math.min(this.energy.getEnergy(), 2.0E9));
        this.expirencelevel1 = ExperienceUtils.getLevelForExperience((int)Math.min(Math.max(this.energy.getEnergy() - 2.0E9, 0.0), 2.0E9));
        this.energy1 = this.energy.getEnergy();
    }
}

