/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.things.fluid;

import com.denfop.IUItem;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerLavaGenerator;
import com.denfop.gui.GuiLavaGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileLavaGenerator
extends TileElectricMachine
implements IUpgradableBlock {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public final InvSlotFluid containerslot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, FluidRegistry.LAVA);
    public final FluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final float energycost;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private double lastEnergy;

    public TileLavaGenerator() {
        super(20000.0, 1, 1);
        this.energycost = 80.0f;
        this.fluidTank = this.fluids.addTank("fluidTank", 20000, InvSlot.TypeItemSlot.OUTPUT, Fluids.fluidPredicate(FluidRegistry.LAVA));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.15));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.3));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.lava_gen;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.lastEnergy = nbt.func_74769_h("lastEnergy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("lastEnergy", this.lastEnergy);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.setUpgradestat();
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.gen_lava.getSoundEvent();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (!(this.energy.getEnergy() <= 0.0) && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            if (this.energy.getEnergy() >= (double)this.energycost) {
                needsInvUpdate = this.attemptGeneration();
                if (this.field_145850_b.field_73011_w.getWorldTime() % 40L == 0L) {
                    this.initiate(0);
                }
            } else if (this.field_145850_b.field_73011_w.getWorldTime() % 40L == 0L) {
                this.initiate(2);
            }
            this.lastEnergy = this.energy.getEnergy();
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (!this.containerslot.isEmpty() && this.fluidTank.getFluidAmount() > 0) {
            this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fillInternal(new FluidStack(FluidRegistry.LAVA, Math.min(m, k)), true);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
        return true;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return "" + p + "%";
    }

    public ContainerLavaGenerator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerLavaGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiLavaGenerator(new ContainerLavaGenerator(entityPlayer, this));
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileLavaGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.FluidExtract);
    }
}

