/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.multiblocks.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.container.ContainerBase;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.items.energy.ItemToolWrench;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.multiblock.TileEntityMultiBlockRender;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileMultiBlockBase
extends TileEntityInventory
implements IMainMultiBlock,
IUpdatableTileEvent {
    private final MultiBlockStructure multiBlockStructure;
    public boolean full;
    public boolean activate;
    public List<EntityPlayer> entityPlayerList;
    @SideOnly(value=Side.CLIENT)
    private Function render;

    public TileMultiBlockBase(MultiBlockStructure multiBlockStructure) {
        this.multiBlockStructure = multiBlockStructure;
        this.full = false;
        this.entityPlayerList = new ArrayList<EntityPlayer>();
        this.activate = false;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        if (!this.isFull()) {
            this.updateFull();
            this.full = true;
            this.activate = true;
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.field_145850_b == null) {
            tooltip.add(Localization.translate("multiblock.jei1"));
            if (this.getMultiBlockStucture() != null) {
                for (ItemStack stack1 : this.getMultiBlockStucture().itemStackList) {
                    if (stack1.func_190926_b()) continue;
                    tooltip.add(TextFormatting.GREEN + "" + stack1.func_190916_E() + "x" + TextFormatting.GRAY + stack1.func_82833_r());
                }
            }
        }
    }

    @Override
    public boolean isMain() {
        return true;
    }

    public MultiBlockStructure getMultiBlockStructure() {
        return this.multiBlockStructure;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.full);
            EncoderHandler.encode(packet, this.activate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onRemovedByPlayer(EntityPlayer player, boolean willHarvest) {
        return true;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.full = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.activate = (Boolean)DecoderHandler.decode(customPacketBuffer);
            if (this.full && this.activate) {
                this.updateFull();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(IBakedModel model, IBlockState state, EnumFacing enumfacing) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        List listQuads = model.func_188616_a(state, enumfacing, 0L);
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = (BakedQuad)listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(TileMultiBlockBase tileEntityMultiBlockBase) {
        if (!this.isFull()) {
            this.renderBlock(tileEntityMultiBlockBase);
        } else if (this.getMultiBlockStucture().hasUniqueModels) {
            this.renderUniqueMultiBlock();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderUniqueMultiBlock() {
    }

    private void rotateBlocks() {
        for (Map.Entry<BlockPos, EnumFacing> entry : this.multiBlockStructure.RotationMap.entrySet()) {
            TileEntityMultiBlockElement multiBlockElement;
            BlockPos pos1;
            EnumFacing rotation = entry.getValue();
            switch (this.getFacing()) {
                case NORTH: {
                    pos1 = entry.getKey();
                    break;
                }
                case EAST: {
                    pos1 = new BlockPos(-entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                    break;
                }
                case WEST: {
                    pos1 = new BlockPos(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), -entry.getKey().func_177958_n());
                    break;
                }
                case SOUTH: {
                    pos1 = new BlockPos(-entry.getKey().func_177958_n(), entry.getKey().func_177956_o(), -entry.getKey().func_177952_p());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.getFacing());
                }
            }
            EnumFacing facing = this.getFacing();
            if ((pos1 = this.field_174879_c.func_177971_a((Vec3i)pos1)).equals((Object)this.field_174879_c)) continue;
            if (facing == EnumFacing.NORTH) {
                if (rotation == EnumFacing.EAST || rotation == EnumFacing.WEST) {
                    rotation = rotation.func_176734_d();
                }
            } else if (facing == EnumFacing.SOUTH) {
                if (rotation == EnumFacing.SOUTH || rotation == EnumFacing.NORTH) {
                    rotation = rotation.func_176734_d();
                }
            } else if (facing == EnumFacing.EAST) {
                rotation = rotation == EnumFacing.EAST || rotation == EnumFacing.WEST ? (rotation == EnumFacing.EAST ? EnumFacing.NORTH : EnumFacing.SOUTH) : (rotation == EnumFacing.SOUTH ? EnumFacing.WEST : EnumFacing.EAST);
            } else if (facing == EnumFacing.WEST) {
                rotation = rotation == EnumFacing.EAST || rotation == EnumFacing.WEST ? (rotation == EnumFacing.WEST ? EnumFacing.NORTH : EnumFacing.SOUTH) : (rotation == EnumFacing.SOUTH ? EnumFacing.EAST : EnumFacing.WEST);
            }
            if ((multiBlockElement = (TileEntityMultiBlockElement)this.func_145831_w().func_175625_s(pos1)) == null) continue;
            multiBlockElement.setFacing(rotation);
        }
    }

    private EnumFacing rotateFacing(EnumFacing original, EnumFacing baseRotation) {
        if (original == EnumFacing.UP || original == EnumFacing.DOWN) {
            return original;
        }
        switch (baseRotation) {
            case EAST: {
                return this.rotate90(original);
            }
            case WEST: {
                return this.rotate90(this.rotate90(this.rotate90(original)));
            }
            case SOUTH: {
                return this.rotate90(this.rotate90(original));
            }
        }
        return original;
    }

    private EnumFacing rotate90(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return facing;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBlock(TileMultiBlockBase tile) {
        if (this.facing == 0 || this.facing == 1) {
            return;
        }
        for (Map.Entry<BlockPos, ItemStack> entry : this.multiBlockStructure.ItemStackMap.entrySet()) {
            BlockPos pos1;
            if (entry.getValue().func_190926_b()) continue;
            EnumFacing rotation = this.multiBlockStructure.RotationMap.get(entry.getKey());
            switch (this.getFacing()) {
                case NORTH: {
                    pos1 = new BlockPos(entry.getKey().func_177958_n(), entry.getKey().func_177956_o(), entry.getKey().func_177952_p());
                    break;
                }
                case EAST: {
                    pos1 = new BlockPos(entry.getKey().func_177952_p() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                    break;
                }
                case WEST: {
                    pos1 = new BlockPos(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n() * -1);
                    break;
                }
                case SOUTH: {
                    pos1 = new BlockPos(entry.getKey().func_177958_n() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177952_p() * -1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.getFacing());
                }
            }
            ItemStack item = entry.getValue();
            if (item.func_190926_b()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)pos1.func_177958_n(), (double)(0.5 + (double)pos1.func_177956_o()), (double)pos1.func_177952_p());
            if (rotation != null && rotation != this.getFacing()) {
                block6 : switch (this.getFacing()) {
                    case NORTH: {
                        switch (rotation) {
                            case SOUTH: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case NORTH: {
                                break;
                            }
                            case WEST: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case EAST: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (rotation) {
                            case SOUTH: {
                                break;
                            }
                            case NORTH: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case WEST: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case EAST: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (rotation) {
                            case SOUTH: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case NORTH: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case WEST: {
                                break;
                            }
                            case EAST: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (rotation) {
                            case SOUTH: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break block6;
                            }
                            case NORTH: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break block6;
                            }
                            case WEST: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break block6;
                            }
                        }
                    }
                }
            }
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            IBakedModel itemModel = this.multiBlockStructure.bakedModelMap.get(entry.getKey());
            if (itemModel == null) {
                itemModel = renderItem.func_184393_a(item, tile.func_145831_w(), null);
                this.multiBlockStructure.bakedModelMap.put(entry.getKey(), itemModel);
            }
            renderItem.func_180454_a(item, itemModel);
            GlStateManager.func_179121_F();
        }
    }

    public abstract void updateAfterAssembly();

    public abstract void usingBeforeGUI();

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer entityPlayer) {
        if (!this.entityPlayerList.contains(entityPlayer)) {
            this.entityPlayerList.add(entityPlayer);
        }
        return null;
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public void setFull(boolean full) {
        if (!full && !this.entityPlayerList.isEmpty()) {
            this.entityPlayerList.forEach(EntityPlayer::func_71053_j);
        }
        this.full = full;
        if (full) {
            this.rotateBlocks();
        }
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "full", full);
        }
    }

    @Override
    public MultiBlockStructure getMultiBlockStucture() {
        return this.multiBlockStructure;
    }

    @Override
    public int getBlockLevel() {
        return 0;
    }

    @Override
    public boolean wasActivated() {
        return this.activate;
    }

    @Override
    public void setActivated(boolean active) {
        this.activate = active;
        new PacketUpdateFieldTile(this, "activate", this.activate);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("full")) {
            try {
                this.full = (Boolean)DecoderHandler.decode(is);
                if (this.full) {
                    this.updateAfterAssembly();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("activate")) {
            try {
                this.activate = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && !this.activate) {
            this.setFull(false);
        }
    }

    @Override
    public void updateFull() {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.getBlockPos(), this.func_145831_w()));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public void loadBeforeFirstClientUpdate() {
        super.loadBeforeFirstClientUpdate();
        if (this.activate) {
            this.updateFull();
            if (this.full) {
                this.updateAfterAssembly();
            } else {
                this.activate = false;
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (this.activate) {
            this.updateFull();
            if (this.full) {
                this.updateAfterAssembly();
            } else {
                this.activate = false;
            }
        }
    }

    @Override
    public void updateFull(EntityPlayer player) {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.getBlockPos(), this.func_145831_w(), player));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.full || !this.activate) {
            this.getCooldownTracker().setTick(1);
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemToolWrench || player.func_184586_b(hand).func_77973_b() == IUItem.GraviTool) {
                return false;
            }
            if (!this.getMultiBlockStucture().isHasActivatedItem()) {
                this.updateFull(player);
                if (this.full) {
                    this.updateAfterAssembly();
                }
                return true;
            }
            if (this.getMultiBlockStucture().isActivateItem(player.func_184586_b(hand))) {
                this.updateFull(player);
                if (!this.full) {
                    return false;
                }
                this.updateAfterAssembly();
            } else if (!this.func_145831_w().field_72995_K) {
                IUCore.proxy.messagePlayer(player, Localization.translate("iu.activate_multiblock") + " " + this.getMultiBlockStucture().getActivateItem().func_82833_r(), new Object[0]);
            }
            return false;
        }
        this.usingBeforeGUI();
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.func_145831_w().field_72995_K) {
            this.render = TileEntityMultiBlockRender.createFunction(this);
            GlobalRenderManager.addRender(this.func_145831_w(), this.field_174879_c, this.render);
        }
    }

    @Override
    public void onBlockBreak(boolean wrench) {
        super.onBlockBreak(wrench);
        if (this.isFull()) {
            if (this.multiBlockStructure != null) {
                List<BlockPos> blockPosList = this.multiBlockStructure.getPoses(this.getFacing(), this.getBlockPos());
                for (BlockPos pos1 : blockPosList) {
                    TileEntity tileentity = this.func_145831_w().func_175625_s(pos1);
                    if (!(tileentity instanceof TileEntityMultiBlockElement)) continue;
                    TileEntityMultiBlockElement te = (TileEntityMultiBlockElement)tileentity;
                    te.setMainMultiElement(null);
                }
            }
            this.setFull(false);
        }
    }

    @Override
    public void onUnloaded() {
        if (this.func_145831_w().field_72995_K) {
            GlobalRenderManager.removeRender(this.func_145831_w(), this.field_174879_c);
        }
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.activate = nbttagcompound.func_74767_n("activate");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("activate", this.activate);
        return nbttagcompound;
    }

    @Override
    public IMainMultiBlock getMain() {
        return this;
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
    }
}

