/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.solarium_storage;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.gui.IType;
import com.denfop.api.sytem.EnergyType;
import com.denfop.blocks.BlockResource;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerSolariumStorage;
import com.denfop.gui.GuiSolariumStorage;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolariumStorage
extends TileEntityInventory
implements IType {
    public final ComponentBaseEnergy se;
    private final EnumTypeStyle enumTypeStyle;

    public TileEntitySolariumStorage(double maxStorage1, EnumTypeStyle enumTypeStyle) {
        this.se = this.addComponent(new ComponentBaseEnergy(EnergyType.SOLARIUM, (TileEntityInventory)this, maxStorage1, Arrays.stream(EnumFacing.field_82609_l).filter(f -> f != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()), EnergyNetGlobal.instance.getTierFromPower(14.0), EnergyNetGlobal.instance.getTierFromPower(14.0), false));
        this.enumTypeStyle = enumTypeStyle;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.se.setDirections(new HashSet<EnumFacing>(Arrays.stream(EnumFacing.field_82609_l).filter(facing1 -> facing1 != EnumFacing.UP && facing1 != this.getFacing()).collect(Collectors.toList())), new HashSet<EnumFacing>(Collections.singletonList(this.getFacing())));
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        double energy1 = nbt.func_74769_h("energy");
        tooltip.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.se.getCapacity()) + " SE");
        if (energy1 != 0.0) {
            tooltip.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(energy1) + "/" + ModUtils.getString(this.se.getCapacity()) + " SE");
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    ComponentBaseEnergy component2 = this.se;
                    if (component2 != null && component2.getEnergy() != 0.0) {
                        NBTTagCompound nbt = ModUtils.nbt(drop);
                        nbt.func_74780_a("energy", component2.getEnergy());
                    }
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack((Block)IUItem.basemachine2, 1, 78);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        ComponentBaseEnergy component2 = this.se;
        if (component2 != null && component2.getEnergy() != 0.0) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74780_a("energy", component2.getEnergy());
        }
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        double energy1 = nbt.func_74769_h("energy");
        if (energy1 != 0.0) {
            this.se.addEnergy(energy1);
        }
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        this.se.setDirections(new HashSet<EnumFacing>(Arrays.asList(EnumFacing.field_82609_l).stream().filter(facing1 -> facing1 != EnumFacing.UP && facing1 != this.getFacing()).collect(Collectors.toList())), new HashSet<EnumFacing>(Collections.singletonList(this.getFacing())));
    }

    public ContainerSolariumStorage getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolariumStorage(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiSolariumStorage(this.getGuiContainer(entityPlayer));
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.enumTypeStyle;
    }
}

