/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.container.ContainerSteamPressureConverter;
import com.denfop.gui.GuiSteamPressureConverter;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySteamPressureConverter
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final PressureComponent pressure;
    public FluidTank fluidTank;
    public Fluids fluids = this.addComponent(new Fluids(this));
    public boolean work = true;
    public short maxpressure = 0;

    public TileEntitySteamPressureConverter() {
        super(0.0, 0, 1);
        this.fluidTank = this.fluids.addTank("fluidTank", 4000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(FluidName.fluidsuperheated_steam.getInstance()));
        this.pressure = this.addComponent(PressureComponent.asBasicSource(this, 4.0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.steam_info"));
        tooltip.add(Localization.translate("iu.steam_info1"));
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.work) {
            if (this.field_174879_c.func_177977_b().func_177951_i((Vec3i)neighborPos) == 0.0) {
                IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
                this.work = blockState.func_185904_a() != Material.field_151579_a ? blockState.func_177230_c() == Blocks.field_150353_l || blockState.func_177230_c() == Blocks.field_150356_k || blockState.func_177230_c() == FluidName.fluidpahoehoe_lava.getInstance().getBlock() : false;
            }
        } else if (this.field_174879_c.func_177977_b().func_177951_i((Vec3i)neighborPos) == 0.0) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
            this.work = blockState.func_185904_a() != Material.field_151579_a ? blockState.func_177230_c() == Blocks.field_150353_l || blockState.func_177230_c() == Blocks.field_150356_k || blockState.func_177230_c() == FluidName.fluidpahoehoe_lava.getInstance().getBlock() : false;
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
            }
            this.maxpressure = (Short)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.steampressureconverter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
            EncoderHandler.encode(packet, this.maxpressure);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
            this.work = blockState.func_185904_a() != Material.field_151579_a ? blockState.func_177230_c() == Blocks.field_150353_l || blockState.func_177230_c() == Blocks.field_150356_k || blockState.func_177230_c() == FluidName.fluidpahoehoe_lava.getInstance().getBlock() : false;
            this.pressure.setCapacity(this.maxpressure);
        }
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i == 0.0) {
            this.maxpressure = (short)(this.maxpressure + 1);
            if (this.maxpressure > 4) {
                this.maxpressure = (short)4;
            }
            this.pressure.setCapacity(this.maxpressure);
        }
        if (i == 1.0) {
            this.maxpressure = (short)(this.maxpressure - 1);
            if (this.maxpressure < 0) {
                this.maxpressure = 0;
            }
            this.pressure.setCapacity(this.maxpressure);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.maxpressure = nbttagcompound.func_74765_d("maxpressure");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("maxpressure", this.maxpressure);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.pressure.storage > (double)this.maxpressure) {
            this.pressure.storage = this.maxpressure;
        }
        if (this.work) {
            if (this.func_145831_w().func_72820_D() % 40L == 0L && this.maxpressure > 0) {
                if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().amount >= this.maxpressure && this.pressure.getEnergy() + 1.0 <= this.pressure.getCapacity()) {
                    this.pressure.addEnergy(1.0);
                    if (this.pressure.storage > (double)this.maxpressure) {
                        this.pressure.storage = this.maxpressure;
                    }
                    this.fluidTank.drain((int)this.maxpressure, true);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            }
        } else {
            this.setActive(false);
        }
        if (this.func_145831_w().func_72820_D() % 400L == 0L) {
            if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().amount >= this.maxpressure) {
                this.fluidTank.drain((int)this.maxpressure, true);
            } else {
                this.pressure.useEnergy(1.0);
            }
        }
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerSteamPressureConverter getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSteamPressureConverter(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiSteamPressureConverter(this.getGuiContainer(entityPlayer), b);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

