/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.container.ContainerSteamPump;
import com.denfop.gui.GuiSteamPump;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileSteamPump
extends TileElectricLiquidTankInventory {
    public final int defaultTier;
    public final double defaultEnergyStorage = this.operationLength;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final PressureComponent pressure;
    public final ComponentSteamEnergy steam;
    private final Fluids.InternalFluidTank fluidTank1;
    public double energyConsume = 2.0;
    public int operationsPerTick;
    public int operationLength = 25;
    public ComponentProgress componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, (short)this.operationLength));

    public TileSteamPump() {
        super(0.0, 1, 10);
        this.defaultEnergyConsume = 2.0;
        this.defaultOperationLength = 25;
        this.defaultTier = 1;
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
        this.fluidTank1 = this.fluids.addTank("fluidTank2", 4000, Fluids.fluidPredicate(FluidName.fluidsteam.getInstance()), InvSlot.TypeItemSlot.NONE);
        this.pressure = this.addComponent(PressureComponent.asBasicSink(this, 1.0));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank1);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.steam_pump;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.steam.canUseEnergy(this.energyConsume)) {
            if (this.componentProgress.getProgress() < this.componentProgress.getMaxValue()) {
                this.componentProgress.addProgress(0);
                this.steam.useEnergy(this.energyConsume);
            } else if (this.canoperate()) {
                this.componentProgress.setProgress((short)0);
            }
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        for (int i = this.field_174879_c.func_177958_n() - 1; i <= this.field_174879_c.func_177958_n() + 1; ++i) {
            for (int j = this.field_174879_c.func_177952_p() - 1; j <= this.field_174879_c.func_177952_p() + 1; ++j) {
                for (int k = this.field_174879_c.func_177956_o() - 3; k <= this.field_174879_c.func_177956_o() - 1; ++k) {
                    if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
                        return false;
                    }
                    FluidStack liquid = this.pump(new BlockPos(i, k, j), false);
                    if (this.getFluidTank().fill(liquid, false) <= 0) continue;
                    this.getFluidTank().fill(liquid, true);
                    canOperate = true;
                }
            }
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        IBlockState block;
        FluidStack ret = null;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.func_145831_w().func_180495_p(pos)).func_185904_a().func_76224_d()) {
            if (block.func_177230_c() instanceof IFluidBlock) {
                IFluidBlock liquid = (IFluidBlock)block.func_177230_c();
                if ((this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == liquid.getFluid()) && liquid.canDrain(this.func_145831_w(), pos)) {
                    if (!sim) {
                        ret = liquid.drain(this.func_145831_w(), pos, true);
                        this.func_145831_w().func_175698_g(pos);
                    } else {
                        ret = new FluidStack(liquid.getFluid(), 1000);
                    }
                }
            } else {
                if (block.func_177230_c().func_176201_c(block) != 0) {
                    return null;
                }
                ret = new FluidStack(FluidRegistry.getFluid((String)block.func_177230_c().func_149739_a().substring(5)), 1000);
                if (!(this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != ret.getFluid() || sim)) {
                    this.func_145831_w().func_175698_g(pos);
                }
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    public ContainerSteamPump getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSteamPump(entityPlayer, this);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiSteamPump getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiSteamPump(this.getGuiContainer(entityPlayer));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

