/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steam;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerSteamTank;
import com.denfop.gui.GuiSteamTank;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.tank.DataFluid;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSteamStorage
extends TileEntityInventory {
    public final Fluids fluids;
    private final ComponentSteamEnergy steam = this.addComponent(new ComponentSteamEnergy(EnergyType.STEAM, (TileEntityInventory)this, 64000.0, Arrays.stream(EnumFacing.field_82609_l).filter(f -> f != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()), EnergyNetGlobal.instance.getTierFromPower(14.0), EnergyNetGlobal.instance.getTierFromPower(14.0), false));
    public FluidTank fluidTank;
    public int prev = -10;
    @SideOnly(value=Side.CLIENT)
    public DataFluid dataFluid;
    public int amount;

    public TileSteamStorage() {
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", 64000, InvSlot.TypeItemSlot.NONE, Fluids.fluidPredicate(FluidName.fluidsteam.getInstance()));
        this.steam.setFluidTank(this.fluidTank);
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public int getLightValue() {
        if (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid().getBlock() == null) {
            return super.getLightValue();
        }
        return this.fluidTank.getFluid().getFluid().getBlock().func_149750_m(this.fluidTank.getFluid().getFluid().getBlock().func_176223_P());
    }

    @Override
    public int getLightOpacity() {
        if (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid().getBlock() == null) {
            return super.getLightOpacity();
        }
        int now = this.fluidTank.getFluid().getFluid().getBlock().func_149717_k(this.fluidTank.getFluid().getFluid().getBlock().func_176223_P());
        if (this.prev != now) {
            this.prev = now;
            try {
                this.func_145831_w().func_175664_x(this.field_174879_c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return now;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.steam_storage;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + fluidStack.getLocalizedName());
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.amount / 1000 + " B");
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid")));
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack, true);
            }
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        if (this.fluidTank.getFluidAmount() > 0) {
            NBTTagCompound nbt = ModUtils.nbt(itemStackList.get(0));
            nbt.func_74782_a("fluid", (NBTBase)this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        return itemStackList;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).func_77969_a(this.getPickBlock(null, null)) && (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self) && this.fluidTank.getFluidAmount() > 0) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74782_a("fluid", (NBTBase)this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        return drop;
    }

    public double gaugeLiquidScaled(double i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0.0 : (double)this.getFluidTank().getFluidAmount() * i / (double)this.getFluidTank().getCapacity();
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean needsFluid() {
        return this.getFluidTank().getFluidAmount() < this.getFluidTank().getCapacity();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.amount != this.fluidTank.getFluidAmount()) {
            this.amount = this.fluidTank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.fluidTank.setFluid(((FluidTank)DecoderHandler.decode(is)).getFluid());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerSteamTank getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSteamTank(entityPlayer, this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.canFill() ? this.getFluidTank().fill(resource, doFill) : 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return !this.canDrain() ? null : this.getFluidTank().drain(maxDrain, doDrain);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiSteamTank(new ContainerSteamTank(entityPlayer, this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
            this.steam.setDirections(new HashSet<EnumFacing>(Arrays.stream(EnumFacing.field_82609_l).filter(facing1 -> facing1 != EnumFacing.UP && facing1 != this.getFacing()).collect(Collectors.toList())), new HashSet<EnumFacing>(Collections.singletonList(this.getFacing())));
        }
    }

    public void setUpgradestat() {
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
        }
    }
}

