/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamboiler;

import com.denfop.IUItem;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSteamBoiler;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.tank.DataFluid;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamboiler.ITank;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySteamTankBoiler
extends TileEntityMultiBlockElement
implements ITank {
    private final Fluids fluids = this.addComponent(new Fluids(this));
    private final Fluids.InternalFluidTank tank = this.fluids.addTank("tank", 4000);
    @SideOnly(value=Side.CLIENT)
    public DataFluid dataFluid;
    private ComponentSteamEnergy steam = this.addComponent(ComponentSteamEnergy.asBasicSource(this, 4000.0));
    private int amount;

    public TileEntitySteamTankBoiler() {
        this.steam.setFluidTank(this.tank);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.tank.setFluid(((FluidTank)DecoderHandler.decode(is)).getFluid());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.tank.setFluid(((FluidTank)DecoderHandler.decode(customPacketBuffer)).getFluid());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, (Object)this.tank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "fluidTank", (Object)this.tank);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.amount != this.tank.getFluidAmount()) {
            this.amount = this.tank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", (Object)this.tank);
        }
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public void setSteam() {
        this.tank.setTypeItemSlot(InvSlot.TypeItemSlot.NONE);
        this.steam.onLoaded();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSteamBoiler.steam_boiler_tank;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.steam_boiler;
    }

    @Override
    public ComponentSteamEnergy getSteam() {
        return this.steam;
    }

    @Override
    public void setUnloaded() {
        this.steam.onUnloaded();
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
        super.setMainMultiElement(main);
        if (main == null && this.steam != null) {
            this.steam.onUnloaded();
        }
    }
}

