/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine;

import com.denfop.IUItem;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSteamTurbine;
import com.denfop.container.ContainerSteamTurbineRod;
import com.denfop.gui.GuiSteamTurbineRod;
import com.denfop.invslot.InvSlot;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamturbine.IRod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySteamTurbineRod
extends TileEntityMultiBlockElement
implements IRod {
    private final InvSlot slot;
    List<ISteamBlade> list = new ArrayList<ISteamBlade>();

    public TileEntitySteamTurbineRod() {
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 4){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ISteamBlade && ((ISteamBlade)stack.func_77973_b()).getLevel() <= TileEntitySteamTurbineRod.this.getMain().getBlockLevel();
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                this.update();
            }

            @Override
            public void update() {
                super.update();
                TileEntitySteamTurbineRod.this.list.clear();
                for (int i = 0; i < this.size(); ++i) {
                    ItemStack stack = this.get(i);
                    if (stack.func_190926_b()) continue;
                    ItemDamage damage = (ItemDamage)stack.func_77973_b();
                    if (damage.getMaxCustomDamage(stack) - damage.getCustomDamage(stack) == 0) {
                        this.put(i, ItemStack.field_190927_a);
                        continue;
                    }
                    TileEntitySteamTurbineRod.this.list.add((ISteamBlade)stack.func_77973_b());
                }
            }
        };
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSteamTurbine.steam_turbine_rod;
    }

    public ContainerSteamTurbineRod getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSteamTurbineRod(this, entityPlayer);
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiSteamTurbineRod(this.getGuiContainer(entityPlayer));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.steam_turbine;
    }

    @Override
    public InvSlot getSlot() {
        return this.slot;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.slot.writeToNbt(new NBTTagCompound()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            NBTTagCompound tagCompound = (NBTTagCompound)DecoderHandler.decode(customPacketBuffer);
            this.slot.readFromNbt(tagCompound);
            this.slot.update();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.slot.update();
    }

    @Override
    public List<ISteamBlade> getRods() {
        return this.list;
    }

    @Override
    public void updateBlades() {
        this.slot.update();
    }
}

