/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine.controller;

import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.steam.EnumSteamPhase;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.api.steam.Steam;
import com.denfop.container.ContainerBaseSteamTurbineController;
import com.denfop.gui.GuiBaseSteamTurbineController;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.render.steam.SteamRod;
import com.denfop.render.windgenerator.WindGeneratorRenderer;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.mechanism.steamturbine.IController;
import com.denfop.tiles.mechanism.steamturbine.IControllerRod;
import com.denfop.tiles.mechanism.steamturbine.ICoolant;
import com.denfop.tiles.mechanism.steamturbine.IExchanger;
import com.denfop.tiles.mechanism.steamturbine.IPressure;
import com.denfop.tiles.mechanism.steamturbine.IRod;
import com.denfop.tiles.mechanism.steamturbine.ISocket;
import com.denfop.tiles.mechanism.steamturbine.ITank;
import com.denfop.world.WorldBaseGen;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class TileEntityBaseSteamTurbineController
extends TileMultiBlockBase
implements IController,
IUpdatableTileEvent {
    private final int level;
    public List<IExchanger> listExchanger = new ArrayList<IExchanger>();
    public List<ICoolant> listCoolant = new ArrayList<ICoolant>();
    public ITank tankWater;
    public ITank tankSteam;
    public IPressure pressure;
    public List<IRod> iRodListMap = new ArrayList<IRod>();
    public EnumSteamPhase enumSteamPhase = EnumSteamPhase.ONE;
    public EnumSteamPhase stableenumSteamPhase = EnumSteamPhase.ONE;
    public int phase = 0;
    public double generation;
    public double heat;
    public boolean work;
    public Steam steam;
    public ISocket energy;
    private long lastcheck;
    private float angle;

    public TileEntityBaseSteamTurbineController(int level) {
        super(InitMultiBlockSystem.SteamTurbineMultiBlock);
        this.level = level;
    }

    @Override
    public int getBlockLevel() {
        return this.level;
    }

    @Override
    public ISocket getEnergy() {
        return this.energy;
    }

    @Override
    public List<ICoolant> getCoolant() {
        return this.listCoolant;
    }

    @Override
    public List<IExchanger> getExchanger() {
        return this.listExchanger;
    }

    public float getAngle() {
        if (this.func_145831_w().field_73011_w.getDimension() != 0) {
            return 0.0f;
        }
        if (this.work && this.phase > 0) {
            long k = System.currentTimeMillis() - this.lastcheck;
            this.angle = (float)((double)this.angle + Math.max(0.025, (double)((float)((double)((float)k * (float)this.phase * (float)this.enumSteamPhase.ordinal()) / 500.0))));
            this.angle %= 360.0f;
        }
        this.lastcheck = System.currentTimeMillis();
        return this.angle;
    }

    @Override
    public FluidTank getSteamFluid() {
        return this.tankSteam.getTank();
    }

    public ContainerBaseSteamTurbineController getGuiContainer(EntityPlayer var1) {
        return new ContainerBaseSteamTurbineController(this, var1);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        try {
            EncoderHandler.encode(customPacketBuffer, this.getSteamFluid());
            EncoderHandler.encode(customPacketBuffer, this.getWaterFluid());
            customPacketBuffer.writeBytes((ByteBuf)this.energy.getEnergy().updateComponent());
            customPacketBuffer.writeInt(this.phase);
            customPacketBuffer.writeInt(this.enumSteamPhase.ordinal());
            customPacketBuffer.writeInt(this.stableenumSteamPhase.ordinal());
            customPacketBuffer.writeDouble(this.heat);
            customPacketBuffer.writeDouble(this.generation);
            customPacketBuffer.writeByte(this.listCoolant.size());
            for (ICoolant coolant : this.listCoolant) {
                EncoderHandler.encode(customPacketBuffer, coolant.getCoolant());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.phase = customPacketBuffer.readInt();
        this.enumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
        this.stableenumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
        this.heat = customPacketBuffer.readDouble();
        this.generation = customPacketBuffer.readDouble();
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.phase);
        customPacketBuffer.writeInt(this.enumSteamPhase.ordinal());
        customPacketBuffer.writeInt(this.stableenumSteamPhase.ordinal());
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeDouble(this.generation);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        if (!this.isFull()) {
            this.updateFull();
        }
        try {
            FluidTank fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank2 != null) {
                this.getSteamFluid().readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
            }
            if ((fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer)) != null) {
                this.getWaterFluid().readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
            }
            this.energy.getEnergy().onNetworkUpdate(customPacketBuffer);
            this.phase = customPacketBuffer.readInt();
            this.enumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
            this.stableenumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
            this.heat = customPacketBuffer.readDouble();
            this.generation = customPacketBuffer.readDouble();
            int col = customPacketBuffer.readByte();
            for (int i = 0; i < col; ++i) {
                ICoolant coolant = this.listCoolant.get(i);
                fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
                if (fluidTank2 == null) continue;
                coolant.getCoolant().readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiBaseSteamTurbineController getGui(EntityPlayer var1, boolean var2) {
        return new GuiBaseSteamTurbineController(this.getGuiContainer(var1));
    }

    @Override
    public FluidTank getWaterFluid() {
        return this.tankWater.getTank();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileMultiBlockBase tileEntityMultiBlockBase) {
        super.render(tileEntityMultiBlockBase);
        if (this.isFull()) {
            int diameter = 2;
            BlockPos prev = this.field_174879_c;
            ModelBase model = WindGeneratorRenderer.rotorModels.get(diameter);
            if (model == null) {
                model = new SteamRod(diameter);
                WindGeneratorRenderer.rotorModels.put(diameter, model);
            }
            if (!(model instanceof SteamRod)) {
                model = new SteamRod(diameter);
                WindGeneratorRenderer.rotorModels.replace(diameter, model);
            }
            if (this.iRodListMap.isEmpty()) {
                List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRod.class);
                for (BlockPos pos2 : pos1) {
                    this.iRodListMap.add((IRod)this.func_145831_w().func_175625_s(pos2));
                }
            }
            for (IRod rod : this.iRodListMap) {
                BlockPos pos = rod.getBlockPos();
                GlStateManager.func_179094_E();
                float angle = this.getAngle();
                GlStateManager.func_179109_b((float)(pos.func_177958_n() - prev.func_177958_n()), (float)(pos.func_177956_o() - prev.func_177956_o()), (float)(pos.func_177952_p() - prev.func_177952_p()));
                EnumFacing facing = this.getFacing();
                switch (facing) {
                    case NORTH: {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
                        GL11.glRotatef((float)angle, (float)(facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)0.0f, (float)(facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
                        GL11.glRotatef((float)angle, (float)(facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)0.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
                        GL11.glRotatef((float)angle, (float)(facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)0.0f, (float)(facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179109_b((float)0.25f, (float)0.5f, (float)0.0f);
                        GL11.glRotatef((float)angle, (float)(facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)0.0f, (float)(facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
                    }
                }
                for (ISteamBlade steamBlade : rod.getRods()) {
                    ResourceLocation rotorRL = steamBlade.getTexture();
                    int light = this.field_145850_b.func_175626_b(pos, 0);
                    int blockLight = light % 65536;
                    int skyLight = light / 65536;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)blockLight, (float)skyLight);
                    if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                        GL11.glRotatef((float)90.0f, (float)(facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)0.0f, (float)(facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
                    } else {
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(rotorRL);
                    model.func_78088_a((Entity)null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    @Override
    public EnumSteamPhase getSteamPhase() {
        return this.enumSteamPhase;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && this.work) {
            if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L) {
                if (this.steam.getCoef() > 0.0) {
                    this.steam.onTick();
                    for (IExchanger exchanger : this.listExchanger) {
                        if (exchanger.getExchanger() == null) continue;
                        this.removeHeat(exchanger.getPower());
                        boolean update = exchanger.getExchanger().damageItem(exchanger.getSlot().get(), -1);
                        if (!update) continue;
                        exchanger.getSlot().put(0, ItemStack.field_190927_a);
                    }
                }
                if (this.func_145831_w().field_73011_w.getWorldTime() % 120L == 0L) {
                    this.removePhase(WorldBaseGen.random.nextInt(this.level + 2));
                }
                this.steam.updateData();
            }
            this.generation = this.steam.getGeneration();
            this.energy.getEnergy().addEnergy(this.generation);
            this.energy.getEnergy().setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.generation));
        } else {
            this.generation = 0.0;
            if (this.func_145831_w().field_73011_w.getWorldTime() % 60L == 0L) {
                this.removePhase(WorldBaseGen.random.nextInt(this.level + 2));
            }
        }
    }

    @Override
    public void addPhase(int phase) {
        int oldphase = this.phase;
        this.phase += phase;
        if (oldphase != this.phase) {
            new PacketUpdateFieldTile(this, "phase", this.phase);
        }
        if (this.enumSteamPhase == this.stableenumSteamPhase && this.phase > this.enumSteamPhase.getMax()) {
            this.phase = this.enumSteamPhase.getMax();
        }
        if (this.phase < this.enumSteamPhase.getMin() || this.phase > this.enumSteamPhase.getMax()) {
            EnumSteamPhase old = this.enumSteamPhase;
            this.recalculatePhase();
            if (old != this.enumSteamPhase) {
                new PacketUpdateFieldTile(this, "enumSteamPhase", this.enumSteamPhase.ordinal());
            }
        }
        if (this.phase > this.enumSteamPhase.getMax()) {
            this.phase = this.enumSteamPhase.getMax();
        }
    }

    private void recalculatePhase() {
        for (EnumSteamPhase enumSteamPhase1 : EnumSteamPhase.values()) {
            if (this.phase < enumSteamPhase1.getMin() || this.phase > enumSteamPhase1.getMax()) continue;
            this.enumSteamPhase = enumSteamPhase1;
            break;
        }
    }

    @Override
    public void removePhase(int phase) {
        int oldphase = this.phase;
        this.phase -= phase;
        if (this.phase < 0) {
            this.phase = 0;
        }
        if (oldphase != this.phase) {
            new PacketUpdateFieldTile(this, "phase", this.phase);
        }
        if (this.phase < this.enumSteamPhase.getMin() || this.phase > this.enumSteamPhase.getMax()) {
            EnumSteamPhase old = this.enumSteamPhase;
            this.recalculatePhase();
            if (old != this.enumSteamPhase) {
                new PacketUpdateFieldTile(this, "enumSteamPhase", this.enumSteamPhase.ordinal());
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.trim().equals("phase")) {
            try {
                this.phase = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.trim().equals("enumSteamPhase")) {
            try {
                this.enumSteamPhase = EnumSteamPhase.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("work", this.work);
        nbttagcompound.func_74774_a("enumSteamPhase", (byte)this.enumSteamPhase.ordinal());
        nbttagcompound.func_74774_a("stableenumSteamPhase", (byte)this.stableenumSteamPhase.ordinal());
        nbttagcompound.func_74777_a("phase", (short)this.phase);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
        this.enumSteamPhase = EnumSteamPhase.values()[nbttagcompound.func_74771_c("enumSteamPhase")];
        this.stableenumSteamPhase = EnumSteamPhase.values()[nbttagcompound.func_74771_c("stableenumSteamPhase")];
        this.phase = nbttagcompound.func_74765_d("phase");
    }

    @Override
    public void updateInfo() {
        this.iRodListMap.forEach(IRod::updateBlades);
    }

    @Override
    public int getPressure() {
        return this.pressure.getPressure();
    }

    @Override
    public List<IRod> getInfo() {
        return this.iRodListMap;
    }

    @Override
    public boolean isWork() {
        return this.work;
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.iRodListMap.clear();
            this.listCoolant.clear();
            this.listExchanger.clear();
            this.pressure = null;
            this.tankWater = null;
            this.tankSteam = null;
            this.energy = null;
        }
    }

    @Override
    public void setGeneration(double generation) {
        this.generation = generation;
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public void removeHeat(double heat) {
        this.heat -= heat;
        if (this.heat < 0.0) {
            this.heat = 0.0;
        }
    }

    @Override
    public void addHeat(double heat) {
        this.heat += heat;
        if (this.heat > this.getMaxHeat()) {
            this.heat = this.getMaxHeat();
        }
    }

    @Override
    public double getMaxHeat() {
        return 500.0;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == 0.0) {
            this.work = !this.work;
        } else if (var2 == 1.0) {
            EnumSteamPhase[] values = EnumSteamPhase.values();
            this.stableenumSteamPhase = values[(this.stableenumSteamPhase.ordinal() + 1) % values.length];
        } else {
            EnumSteamPhase[] values = EnumSteamPhase.values();
            this.stableenumSteamPhase = values[Math.max(0, this.stableenumSteamPhase.ordinal() - 1)];
        }
    }

    @Override
    public EnumSteamPhase getStableSteamPhase() {
        return this.stableenumSteamPhase;
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IPressure.class);
        this.pressure = (IPressure)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        this.energy = (ISocket)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        this.tankWater = (ITank)this.func_145831_w().func_175625_s(pos1.get(0));
        this.tankWater.setWaterTank();
        this.tankWater.clear(false);
        this.tankSteam = (ITank)this.func_145831_w().func_175625_s(pos1.get(1));
        this.tankSteam.setSteamTank();
        this.tankSteam.clear(true);
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICoolant.class);
        for (BlockPos pos2 : pos1) {
            this.listCoolant.add((ICoolant)this.func_145831_w().func_175625_s(pos2));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IExchanger.class);
        for (BlockPos pos2 : pos1) {
            this.listExchanger.add((IExchanger)this.func_145831_w().func_175625_s(pos2));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRod.class);
        for (BlockPos pos2 : pos1) {
            this.iRodListMap.add((IRod)this.func_145831_w().func_175625_s(pos2));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IControllerRod.class);
        IControllerRod controllerRod = (IControllerRod)this.func_145831_w().func_175625_s(pos1.get(0));
        controllerRod.setList(this.iRodListMap);
        this.steam = new Steam(this);
    }

    @Override
    public void usingBeforeGUI() {
    }
}

