/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine.coolant;

import com.denfop.blocks.FluidName;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerSteamTurbineCoolant;
import com.denfop.gui.GuiSteamTurbineCoolant;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamturbine.ICoolant;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseSteamTurbineCoolant
extends TileEntityMultiBlockElement
implements ICoolant,
IUpdatableTileEvent {
    private final Fluids fluids;
    private final int level;
    private final Fluids.InternalFluidTank tank;
    double power = 0.0;
    Fluid currentStack = null;
    private int x = 1;

    public TileEntityBaseSteamTurbineCoolant(int level) {
        this.level = level;
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 10000);
        this.getFluidsFromLevel();
    }

    private void getFluidsFromLevel() {
        ArrayList<Fluid> fluidList = new ArrayList<Fluid>();
        switch (this.level) {
            default: {
                fluidList.add(FluidName.fluidhyd.getInstance());
                break;
            }
            case 1: {
                fluidList.add(FluidName.fluidhyd.getInstance());
                fluidList.add(FluidName.fluidazot.getInstance());
                fluidList.add(FluidName.fluidcoolant.getInstance());
                break;
            }
            case 2: {
                fluidList.add(FluidName.fluidhyd.getInstance());
                fluidList.add(FluidName.fluidazot.getInstance());
                fluidList.add(FluidName.fluidcoolant.getInstance());
                fluidList.add(FluidName.fluidHelium.getInstance());
                break;
            }
            case 3: {
                fluidList.add(FluidName.fluidhyd.getInstance());
                fluidList.add(FluidName.fluidazot.getInstance());
                fluidList.add(FluidName.fluidcoolant.getInstance());
                fluidList.add(FluidName.fluidHelium.getInstance());
                fluidList.add(FluidName.fluidcryogen.getInstance());
            }
        }
        this.tank.setAcceptedFluids(Fluids.fluidPredicate(fluidList));
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && this.getMain() != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.x);
        customPacketBuffer.writeDouble(this.power);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.x = customPacketBuffer.readInt();
        this.power = customPacketBuffer.readDouble();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSteamTurbineCoolant(this.getGuiContainer(var1));
    }

    public ContainerSteamTurbineCoolant getGuiContainer(EntityPlayer var1) {
        return new ContainerSteamTurbineCoolant(this, var1);
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.x = nbtTagCompound.func_74762_e("coolant_x");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("coolant_x", this.x);
        return nbtTagCompound;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (this.getMain() == null) {
            return;
        }
        this.x = var2 == 0.0 ? Math.min(this.x + 1, this.level + 2) : Math.max(0, this.x - 1);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.tank.getFluid() != null) {
            this.currentStack = this.tank.getFluid().getFluid();
            this.power = this.getPowerFromFluid();
        } else {
            this.currentStack = null;
            this.power = 0.0;
        }
    }

    private double getPowerFromFluid() {
        Fluid hyd = FluidName.fluidhyd.getInstance();
        Fluid hel = FluidName.fluidHelium.getInstance();
        Fluid coolant = FluidName.fluidcoolant.getInstance();
        Fluid nitrogen = FluidName.fluidazot.getInstance();
        Fluid cryogen = FluidName.fluidcryogen.getInstance();
        if (this.currentStack == hyd) {
            this.power = 1.0;
        } else if (this.currentStack == nitrogen) {
            this.power = 1.5;
        } else if (this.currentStack == coolant) {
            this.power = 2.5;
        } else if (this.currentStack == hel) {
            this.power = 4.0;
        } else if (this.currentStack == cryogen) {
            this.power = 8.0;
        }
        return this.power;
    }

    @Override
    public FluidTank getCoolant() {
        return this.tank;
    }

    @Override
    public double getPower() {
        return this.power * (double)this.x;
    }

    @Override
    public int getPressure() {
        return this.x;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }
}

