/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine.exchanger;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.container.ContainerBaseSteamTurbineExchanger;
import com.denfop.gui.GuiBaseSteamTurbineExchanger;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamturbine.IController;
import com.denfop.tiles.mechanism.steamturbine.IExchanger;
import com.denfop.tiles.reactors.graphite.IExchangerItem;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseSteamTurbineExchanger
extends TileEntityMultiBlockElement
implements IExchanger {
    private final int level;
    private final InvSlot slot;
    public double percent = 1.0;
    private IExchangerItem item;

    public TileEntityBaseSteamTurbineExchanger(int level) {
        this.level = level;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.EXCHANGE;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof IExchangerItem && ((IExchangerItem)stack.func_77973_b()).getLevel() <= ((IController)TileEntityBaseSteamTurbineExchanger.this.getMain()).getBlockLevel();
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (!((TileEntityBaseSteamTurbineExchanger)TileEntityBaseSteamTurbineExchanger.this).field_145850_b.field_72995_K) {
                    if (content.func_190926_b()) {
                        ((TileEntityBaseSteamTurbineExchanger)this.base).percent = 0.0;
                    } else {
                        ((TileEntityBaseSteamTurbineExchanger)this.base).percent = ((IExchangerItem)content.func_77973_b()).getPercent();
                        TileEntityBaseSteamTurbineExchanger.this.item = (IExchangerItem)content.func_77973_b();
                    }
                }
            }
        };
        this.slot.setStackSizeLimit(1);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            if (this.getSlot().get().func_190926_b()) {
                this.percent = 0.0;
                this.item = null;
            } else {
                this.percent = ((IExchangerItem)this.getSlot().get().func_77973_b()).getPercent();
                this.item = (IExchangerItem)this.getSlot().get().func_77973_b();
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeDouble(this.percent);
        return customPacketBuffer;
    }

    public ContainerBaseSteamTurbineExchanger getGuiContainer(EntityPlayer var1) {
        return new ContainerBaseSteamTurbineExchanger(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiBaseSteamTurbineExchanger(this.getGuiContainer(var1));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.percent = customPacketBuffer.readDouble();
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }

    @Override
    public InvSlot getSlot() {
        return this.slot;
    }

    @Override
    public double getPower() {
        if (this.getMain() == null || this.getSlot().isEmpty()) {
            return 1.0;
        }
        return this.percent * 2.0;
    }

    @Override
    public IExchangerItem getExchanger() {
        return this.item;
    }
}

