/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine.pressure;

import com.denfop.container.ContainerSteamTurbinePressure;
import com.denfop.gui.GuiSteamTurbinePressure;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamturbine.IPressure;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseSteamTurbinePressure
extends TileEntityMultiBlockElement
implements IPressure,
IUpdatableTileEvent {
    private final int level;
    private int pressure;

    public TileEntityBaseSteamTurbinePressure(int level) {
        this.level = level;
        this.pressure = 1;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.pressure = customPacketBuffer.readInt();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.pressure);
        return customPacketBuffer;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.pressure = nbtTagCompound.func_74762_e("pressure");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("pressure", this.pressure);
        return nbtTagCompound;
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    public ContainerSteamTurbinePressure getGuiContainer(EntityPlayer var1) {
        return new ContainerSteamTurbinePressure(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSteamTurbinePressure(this.getGuiContainer(var1));
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.pressure = var2 == 0.0 ? Math.min(this.level + 2, this.pressure + 1) : Math.max(1, this.pressure - 1);
    }
}

