/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine.tank;

import com.denfop.blocks.FluidName;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerSteamTurbineTank;
import com.denfop.gui.GuiSteamTurbineTank;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.tank.DataFluid;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamturbine.ITank;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseSteamTurbineTank
extends TileEntityMultiBlockElement
implements ITank {
    private final int level;
    private final Fluids fluids;
    private final Fluids.InternalFluidTank tank;
    @SideOnly(value=Side.CLIENT)
    public DataFluid dataFluid;
    private int amount;

    public TileEntityBaseSteamTurbineTank(int level) {
        this.level = level;
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 10000 * (level + 1));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.amount != this.tank.getFluidAmount()) {
            this.amount = this.tank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", (Object)this.tank);
        }
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.tank.setFluid(((FluidTank)DecoderHandler.decode(is)).getFluid());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && this.getMain() != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSteamTurbineTank(this.getGuiContainer(var1));
    }

    public ContainerSteamTurbineTank getGuiContainer(EntityPlayer var1) {
        return new ContainerSteamTurbineTank(this, var1);
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public void setWaterTank() {
        this.tank.setAcceptedFluids(Fluids.fluidPredicate(FluidRegistry.WATER));
        this.tank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
    }

    @Override
    public void setSteamTank() {
        this.tank.setAcceptedFluids(Fluids.fluidPredicate(FluidName.fluidsteam.getInstance()));
        this.tank.setTypeItemSlot(InvSlot.TypeItemSlot.INPUT);
    }

    @Override
    public void clear(boolean steam) {
        if (steam) {
            if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER) {
                this.tank.drain(this.tank.getFluidAmount(), true);
            }
        } else if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidName.fluidsteam.getInstance()) {
            this.tank.drain(this.tank.getFluidAmount(), true);
        }
    }
}

