/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.vending;

import com.denfop.api.gui.IType;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerVending;
import com.denfop.gui.GuiVending;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseVending
extends TileEntityInventory
implements IType {
    public final EnumTypeStyle style;
    public final InvSlot invSlotInventoryInput;
    public final InvSlotOutput output;
    public InvSlot invSlotBuy;
    public InvSlot invSlotSell;
    public InvSlot invSlotBuyPrivate;
    public InvSlot invSlotSellPrivate;
    public boolean update;
    public int timer = 0;
    Map<Item, Map<Integer, Integer>> mapValues = new HashMap<Item, Map<Integer, Integer>>();

    public TileEntityBaseVending(EnumTypeStyle style) {
        this.style = style;
        this.invSlotBuyPrivate = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, style.ordinal() + 1);
        this.invSlotSellPrivate = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, style.ordinal() + 1);
        this.invSlotBuy = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, style.ordinal() + 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return !TileEntityBaseVending.this.invSlotBuyPrivate.get(index).func_190926_b() && TileEntityBaseVending.this.invSlotBuyPrivate.get(index).func_77969_a(stack);
            }
        };
        this.invSlotSell = new InvSlot(this, InvSlot.TypeItemSlot.OUTPUT, style.ordinal() + 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return false;
            }
        };
        this.invSlotInventoryInput = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 18){

            @Override
            public void onChanged() {
                super.onChanged();
                TileEntityBaseVending.this.update = true;
            }
        };
        this.output = new InvSlotOutput(this, 18);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.timer += 5;
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    public void updateItems() {
        this.mapValues.clear();
        for (ItemStack stack : this.invSlotInventoryInput) {
            if (stack.func_190926_b()) continue;
            Map map = this.mapValues.computeIfAbsent(stack.func_77973_b(), k -> new HashMap());
            int value = map.computeIfAbsent(stack.func_77952_i(), k -> 0);
            map.replace(stack.func_77952_i(), value += stack.func_190916_E());
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.updateItems();
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            InvSlot slot = (InvSlot)DecoderHandler.decode(customPacketBuffer);
            InvSlot slot1 = (InvSlot)DecoderHandler.decode(customPacketBuffer);
            for (int i = 0; i < slot.size(); ++i) {
                this.invSlotBuyPrivate.set(i, slot.get(i));
                this.invSlotSellPrivate.set(i, slot1.get(i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.invSlotBuyPrivate);
            EncoderHandler.encode(customPacketBuffer, this.invSlotSellPrivate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiVending(this.getGuiContainer(var1), this.getComponentPrivate().getPlayers().contains(var1.func_70005_c_()));
    }

    public ContainerVending getGuiContainer(EntityPlayer var1) {
        return new ContainerVending(this, var1, this.getComponentPrivate().getPlayers().contains(var1.func_70005_c_()));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.update) {
            this.update = false;
            this.updateItems();
        }
        if (this.timer > 0) {
            --this.timer;
        }
        for (int i = 0; i < this.invSlotBuy.size(); ++i) {
            int meta;
            int value;
            ItemStack privateStack;
            ItemStack stack = this.invSlotBuy.get(i);
            if (stack.func_190926_b() || (privateStack = this.invSlotBuyPrivate.get(i)).func_190926_b()) continue;
            if (!stack.func_77969_a(privateStack)) {
                return;
            }
            ItemStack privateSell = this.invSlotSellPrivate.get(i);
            if (privateSell.func_190926_b()) continue;
            ItemStack output = this.invSlotSell.get(i);
            Map map = this.mapValues.computeIfAbsent(privateSell.func_77973_b(), k -> new HashMap());
            if (map.isEmpty() || (value = ((Integer)map.get(meta = privateSell.func_77952_i())).intValue()) <= 0) continue;
            int countCan = output.func_190926_b() ? privateSell.func_77976_d() / privateSell.func_190916_E() : (privateSell.func_77976_d() - output.func_190916_E()) / privateSell.func_190916_E();
            countCan = Math.min(value / privateSell.func_190916_E(), countCan);
            if ((countCan = Math.min(countCan, stack.func_190916_E() / privateStack.func_190916_E())) == 0) continue;
            int totalFreeSpace = 0;
            for (ItemStack outStack : this.output) {
                if (outStack.func_190926_b()) {
                    totalFreeSpace += privateStack.func_77976_d();
                    continue;
                }
                if (!outStack.func_77969_a(privateStack)) continue;
                totalFreeSpace += privateStack.func_77976_d() - outStack.func_190916_E();
            }
            int maxByOutput = totalFreeSpace / privateStack.func_190916_E();
            int countCan1 = Math.min(maxByOutput, countCan);
            if (countCan1 == 0) continue;
            for (ItemStack stack1 : this.invSlotInventoryInput) {
                if (countCan == 0) break;
                if (!stack1.func_77969_a(privateSell)) continue;
                int shrink = Math.min(countCan, stack1.func_190916_E());
                stack1.func_190918_g(privateSell.func_190916_E() * shrink);
                countCan -= shrink;
            }
            stack.func_190918_g(countCan1 * privateStack.func_190916_E());
            this.output.add(ModUtils.setSize(privateStack, countCan1 * privateStack.func_190916_E()));
            this.invSlotSell.add(ModUtils.setSize(privateSell, countCan1 * privateSell.func_190916_E()));
            this.updateItems();
        }
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.style;
    }
}

