/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.panels.entity;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.SunCoef;
import com.denfop.api.solar.EnumSolarType;
import com.denfop.api.solar.EnumTypeParts;
import com.denfop.api.solar.ISolarTile;
import com.denfop.api.solar.SolarEnergySystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentMiniPanel;
import com.denfop.componets.ComponentPollution;
import com.denfop.componets.ComponentTimer;
import com.denfop.container.ContainerMiniPanels;
import com.denfop.gui.GuiMiniPanel;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotGlassMiniPanels;
import com.denfop.invslot.InvSlotOutputMiniPanels;
import com.denfop.invslot.InvSlotStorageMiniPanels;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMiniPanels
extends TileEntityInventory
implements ISolarTile {
    public final InvSlotStorageMiniPanels invSlotStorage;
    public final InvSlotOutputMiniPanels invSlotOutput;
    public final ComponentTimer timer;
    public final InvSlot invSlotCore;
    public ComponentMiniPanel component;
    public InvSlotGlassMiniPanels invSlotGlass;
    public ComponentPollution pollution;
    public boolean canRain;
    public boolean hasSky;
    public Biome biome;
    public boolean wetBiome;
    public boolean noSunWorld;
    public boolean rain;
    public boolean sunIsUp;
    public boolean skyIsVisible;
    public List<List<EnumState>> listStable = new ArrayList<List<EnumState>>(9);
    public double bonusGeneration;
    public TileSolarPanel.GenerationState activeState = TileSolarPanel.GenerationState.NONE;
    public double load;
    public double genDay = 0.0;
    public double genNight = 0.0;
    public double genDayNight = 0.0;
    public double generating;
    private int level;
    private SunCoef sunCoef;

    public TileEntityMiniPanels() {
        this.component = this.addComponent(ComponentMiniPanel.asBasicSource(this, 0.0, 14));
        this.invSlotGlass = new InvSlotGlassMiniPanels(this);
        this.invSlotStorage = new InvSlotStorageMiniPanels(this);
        this.invSlotOutput = new InvSlotOutputMiniPanels(this);
        this.invSlotCore = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 2){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() == IUItem.core;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                SolarEnergySystem.system.calculateCores((TileEntityMiniPanels)this.base);
                SolarEnergySystem.system.recalculation((TileEntityMiniPanels)this.base, EnumTypeParts.GENERATION);
            }
        };
        this.pollution = this.addComponent(new ComponentPollution(this));
        this.timer = this.addComponent(new ComponentTimer(this, new Timer(3, 0, 0), new Timer(2, 30, 0), new Timer(2, 0, 0)));
        this.pollution.setTimer(this.timer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, List<String> info) {
        if (this.func_145831_w() != null) {
            if (this.field_145850_b.func_72935_r()) {
                info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.generating) + " EF/t ");
                info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.genNight) + " EF/t ");
            } else {
                info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.genDay) + " EF/t ");
                info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.generating) + " EF/t ");
            }
            info.add(Localization.translate("iu.item.tooltip.Output") + " " + ModUtils.getString(this.component.getProdution()) + " EF/t ");
            info.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.component.storage) + " EF ");
            info.add(Localization.translate("iu.tier") + ModUtils.getString(this.component.getSourceTier()));
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.minipanel;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.generating = (Double)DecoderHandler.decode(customPacketBuffer);
            this.invSlotGlass.readFromNbt(this.getNBTFromSlot(customPacketBuffer));
            this.invSlotStorage.readFromNbt(this.getNBTFromSlot(customPacketBuffer));
            this.invSlotOutput.readFromNbt(this.getNBTFromSlot(customPacketBuffer));
            this.bonusGeneration = (Double)DecoderHandler.decode(customPacketBuffer);
            this.rain = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.noSunWorld = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.hasSky = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.skyIsVisible = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.load = (Double)DecoderHandler.decode(customPacketBuffer);
            this.listStable = (List)DecoderHandler.decode(customPacketBuffer);
            this.sunIsUp = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.level = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.generating);
            EncoderHandler.encode(packet, this.invSlotGlass);
            EncoderHandler.encode(packet, this.invSlotStorage);
            EncoderHandler.encode(packet, this.invSlotOutput);
            EncoderHandler.encode(packet, this.bonusGeneration);
            EncoderHandler.encode(packet, this.rain);
            EncoderHandler.encode(packet, this.noSunWorld);
            EncoderHandler.encode(packet, this.hasSky);
            EncoderHandler.encode(packet, this.skyIsVisible);
            EncoderHandler.encode(packet, this.load);
            EncoderHandler.encode(packet, this.listStable);
            EncoderHandler.encode(packet, this.sunIsUp);
            EncoderHandler.encode(packet, this.level);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void setCapacity(double capacity) {
        this.component.setCapacity(capacity);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.pollution, false);
            EncoderHandler.encode(packet, this.timer, false);
            EncoderHandler.encode(packet, this.component, false);
            EncoderHandler.encode(packet, this.invSlotGlass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.pollution.onNetworkUpdate(customPacketBuffer);
            this.timer.onNetworkUpdate(customPacketBuffer);
            this.component.onNetworkUpdate(customPacketBuffer);
            this.invSlotGlass.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void gainFuel() {
        double coefpollution = 1.0;
        switch (this.timer.getIndexWork()) {
            case -1: {
                coefpollution = 0.25;
                break;
            }
            case 1: {
                coefpollution = 0.75;
                break;
            }
            case 2: {
                coefpollution = 0.5;
            }
        }
        switch (this.activeState) {
            case DAY: {
                this.generating = (this.genDay + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case NIGHT: {
                this.generating = (this.genNight + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case RAINDAY: {
                this.generating = 0.65 * (this.genDay + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case RAINNIGHT: {
                this.generating = 0.65 * (this.genNight + this.genDayNight) * (1.0 + this.bonusGeneration);
                break;
            }
            case NETHER: 
            case END: 
            case NONE: {
                this.generating = 0.0;
            }
        }
        this.generating *= coefpollution * this.experimental_generating();
    }

    private double experimental_generating() {
        if (this.sunCoef == null) {
            this.sunCoef = EnergyNetGlobal.instance.getSunCoefficient(this.field_145850_b);
        }
        return this.sunCoef.getCoef();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.canRain = this.field_145850_b.func_180494_b(this.field_174879_c).func_76738_d() || this.field_145850_b.func_180494_b(this.field_174879_c).func_76727_i() > 0.0f;
            this.hasSky = !this.field_145850_b.field_73011_w.func_177495_o();
            this.biome = this.field_145850_b.func_180494_b(this.field_174879_c);
            this.updateVisibility();
            SolarEnergySystem.system.calculateCores(this);
            SolarEnergySystem.system.recalculation(this, EnumTypeParts.GENERATION);
            SolarEnergySystem.system.recalculation(this, EnumTypeParts.OUTPUT);
            SolarEnergySystem.system.recalculation(this, EnumTypeParts.CAPACITY);
            IAdvEnergyNet advEnergyNet = EnergyNetGlobal.instance;
            this.sunCoef = advEnergyNet.getSunCoefficient(this.field_145850_b);
        }
    }

    public void updateVisibility() {
        this.wetBiome = this.biome.func_76727_i() > 0.0f;
        this.noSunWorld = this.field_145850_b.field_73011_w.func_177495_o();
        this.rain = this.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.sunIsUp = this.field_145850_b.func_72935_r();
        boolean bl = this.skyIsVisible = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b && !this.noSunWorld;
        if (!this.skyIsVisible) {
            this.activeState = TileSolarPanel.GenerationState.NONE;
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? TileSolarPanel.GenerationState.DAY : TileSolarPanel.GenerationState.RAINDAY;
        }
        if (!this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? TileSolarPanel.GenerationState.NIGHT : TileSolarPanel.GenerationState.RAINNIGHT;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == 1) {
            this.activeState = TileSolarPanel.GenerationState.END;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == -1) {
            this.activeState = TileSolarPanel.GenerationState.NETHER;
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 80L == 0L) {
            this.updateVisibility();
        }
        this.timer.setCanWork(!this.invSlotGlass.isEmpty());
        this.generating = 0.0;
        if (this.load >= 100.0) {
            return;
        }
        this.gainFuel();
        this.component.addEnergy(this.generating);
    }

    @Override
    public void setOutput(double output) {
        this.component.setProdution(output);
    }

    @Override
    public void setGeneration(EnumSolarType solarType, double generation) {
        switch (solarType) {
            case DAY: {
                this.genDay = generation;
                break;
            }
            case NIGHT: {
                this.genNight = generation;
                break;
            }
            case DAY_NIGHT: {
                this.genDayNight = generation;
            }
        }
    }

    @Override
    public List<ItemStack> getCapacityItems() {
        return this.invSlotStorage;
    }

    @Override
    public List<ItemStack> getOutputItems() {
        return this.invSlotOutput;
    }

    @Override
    public List<ItemStack> getGenerationItems() {
        return this.invSlotGlass;
    }

    @Override
    public void setBonus(EnumTypeParts typeBonus, double bonus) {
        switch (typeBonus) {
            case OUTPUT: {
                this.component.setBonusProdution(bonus);
                break;
            }
            case CAPACITY: {
                this.component.setBonusCapacity(bonus);
                break;
            }
            case GENERATION: {
                this.bonusGeneration = bonus;
            }
        }
    }

    @Override
    public double getBonus(EnumTypeParts typeBonus) {
        switch (typeBonus) {
            case OUTPUT: {
                return this.component.getBonusProdution();
            }
            case CAPACITY: {
                return this.component.getBonusCapacity();
            }
            case GENERATION: {
                return this.bonusGeneration;
            }
        }
        return 0.0;
    }

    @Override
    public void setLoad(double load) {
        this.load = load;
    }

    @Override
    public List<List<EnumState>> getStables() {
        return this.listStable;
    }

    @Override
    public void setStables(int index, List<EnumState> enumStateList) {
        if (index < this.listStable.size()) {
            this.listStable.set(index, enumStateList);
        } else {
            this.listStable.add(index, enumStateList);
        }
    }

    @Override
    public List<ItemStack> getCoresItems() {
        return this.invSlotCore;
    }

    @Override
    public int getCoreLevel() {
        return this.level;
    }

    @Override
    public void setCoreLevel(int level) {
        this.level = level;
    }

    public ContainerMiniPanels getGuiContainer(EntityPlayer var1) {
        return new ContainerMiniPanels(this, var1);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiMiniPanel getGui(EntityPlayer var1, boolean var2) {
        return new GuiMiniPanel(this.getGuiContainer(var1));
    }

    public static enum EnumState {
        STABLE,
        UNSTABLE,
        NORMAL,
        EMPTY;

    }
}

