/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockEarthQuarry;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerEarthController;
import com.denfop.gui.GuiEarthController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.quarry_earth.DataPos;
import com.denfop.tiles.quarry_earth.IAnalyzer;
import com.denfop.tiles.quarry_earth.IEarthChest;
import com.denfop.tiles.quarry_earth.IEarthQuarry;
import com.denfop.tiles.quarry_earth.IRigDrill;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEarthQuarryController
extends TileMultiBlockBase
implements IEarthQuarry,
IUpdatableTileEvent {
    public static List<ChunkPos> chunkPos = new LinkedList<ChunkPos>();
    public static Random random = new Random();
    public final Energy energy;
    public List<IEarthChest> earthChestList = new ArrayList<IEarthChest>();
    public IAnalyzer analyzer;
    public boolean work;
    public int indexChunk = 0;
    public Map<ChunkPos, List<DataPos>> map;
    public List<ChunkPos> chunkPosList;
    public int max = 0;
    public int block_Col;
    private List<DataPos> dataPos = new LinkedList<DataPos>();
    private IRigDrill quarry;
    List<DataPos> notAddedPos = new ArrayList<DataPos>();

    public TileEntityEarthQuarryController() {
        super(InitMultiBlockSystem.EarthQuarryMultiBlock);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 100000.0, 14));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
        this.indexChunk = nbttagcompound.func_74762_e("indexChunk");
        this.max = nbttagcompound.func_74762_e("max");
        this.block_Col = nbttagcompound.func_74762_e("block_Col");
        this.dataPos = new ArrayList<DataPos>();
        NBTTagList dataPosList = nbttagcompound.func_150295_c("DataPosList", 10);
        for (int i = 0; i < dataPosList.func_74745_c(); ++i) {
            this.dataPos.add(DataPos.load(dataPosList.func_150305_b(i)));
        }
        this.notAddedPos = new ArrayList<DataPos>();
        NBTTagList nodAddedDataPosList = nbttagcompound.func_150295_c("nodAddedDataPosList", 10);
        for (int i = 0; i < nodAddedDataPosList.func_74745_c(); ++i) {
            this.notAddedPos.add(DataPos.load(nodAddedDataPosList.func_150305_b(i)));
        }
        this.chunkPosList = new ArrayList<ChunkPos>();
        NBTTagList chunkList = nbttagcompound.func_150295_c("ChunkPosList", 10);
        for (int i = 0; i < chunkList.func_74745_c(); ++i) {
            NBTTagCompound cpTag = chunkList.func_150305_b(i);
            this.chunkPosList.add(new ChunkPos(cpTag.func_74762_e("x"), cpTag.func_74762_e("z")));
        }
        this.map = new HashMap<ChunkPos, List<DataPos>>();
        NBTTagList mapList = nbttagcompound.func_150295_c("ChunkDataMap", 10);
        for (int i = 0; i < mapList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = mapList.func_150305_b(i);
            ChunkPos pos = new ChunkPos(entryTag.func_74762_e("x"), entryTag.func_74762_e("z"));
            NBTTagList dpList = entryTag.func_150295_c("data", 10);
            ArrayList<DataPos> list = new ArrayList<DataPos>();
            for (int j = 0; j < dpList.func_74745_c(); ++j) {
                list.add(DataPos.load(dpList.func_150305_b(j)));
            }
            this.map.put(pos, list);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("work", this.work);
        nbttagcompound.func_74768_a("indexChunk", this.indexChunk);
        nbttagcompound.func_74768_a("max", this.max);
        nbttagcompound.func_74768_a("block_Col", this.block_Col);
        NBTTagList dataPosList = new NBTTagList();
        for (DataPos dataPos : this.dataPos) {
            dataPosList.func_74742_a((NBTBase)dataPos.save());
        }
        nbttagcompound.func_74782_a("DataPosList", (NBTBase)dataPosList);
        NBTTagList nodAddedDataPosList = new NBTTagList();
        for (DataPos dataPos : this.notAddedPos) {
            nodAddedDataPosList.func_74742_a((NBTBase)dataPos.save());
        }
        nbttagcompound.func_74782_a("nodAddedDataPosList", (NBTBase)nodAddedDataPosList);
        NBTTagList nBTTagList = new NBTTagList();
        for (ChunkPos pos : this.chunkPosList) {
            NBTTagCompound cpTag = new NBTTagCompound();
            cpTag.func_74768_a("x", pos.field_77276_a);
            cpTag.func_74768_a("z", pos.field_77275_b);
            nBTTagList.func_74742_a((NBTBase)cpTag);
        }
        nbttagcompound.func_74782_a("ChunkPosList", (NBTBase)nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (Map.Entry<ChunkPos, List<DataPos>> entry : this.map.entrySet()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74768_a("x", entry.getKey().field_77276_a);
            entryTag.func_74768_a("z", entry.getKey().field_77275_b);
            NBTTagList dpList = new NBTTagList();
            for (DataPos dp : entry.getValue()) {
                dpList.func_74742_a((NBTBase)dp.save());
            }
            entryTag.func_74782_a("data", (NBTBase)dpList);
            nBTTagList2.func_74742_a((NBTBase)entryTag);
        }
        nbttagcompound.func_74782_a("ChunkDataMap", (NBTBase)nBTTagList2);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.earthQuarry;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockEarthQuarry.earth_controller;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.max);
        customPacketBuffer.writeInt(this.indexChunk);
        customPacketBuffer.writeInt(this.block_Col);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.max = customPacketBuffer.readInt();
        this.indexChunk = customPacketBuffer.readInt();
        this.block_Col = customPacketBuffer.readInt();
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == 0.0 && !this.analyzer.getChunkPoses().isEmpty()) {
            this.work = !this.work;
            this.indexChunk = 0;
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.full && this.func_145831_w().field_73011_w.getWorldTime() % 10L == 0L) {
            if (this.analyzer.fullAnalyzed() && !this.chunkPosList.isEmpty()) {
                List dataPos = this.map.getOrDefault(this.chunkPosList.get(this.indexChunk), Collections.emptyList());
                this.max = this.chunkPosList.size();
                for (DataPos dataPos1 : dataPos) {
                    if (this.energy.getEnergy() < 50.0) {
                        this.notAddedPos.add(dataPos1);
                        continue;
                    }
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.func_177230_c() == Blocks.field_150346_d) {
                        if (random.nextInt(100) < 90) continue;
                        this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(1));
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.func_177230_c() == Blocks.field_150351_n) {
                        if (random.nextInt(100) < 94) continue;
                        this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(2));
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.func_177230_c() != Blocks.field_150354_m || random.nextInt(100) < 80) continue;
                    this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(0));
                    this.dataPos.add(dataPos1);
                }
                this.block_Col = this.dataPos.size();
                chunkPos.add(this.chunkPosList.get(this.indexChunk));
                ++this.indexChunk;
                if (this.indexChunk == this.chunkPosList.size()) {
                    this.quarry.startOperation(this.dataPos);
                    this.chunkPosList.clear();
                    this.work = false;
                }
            } else if (!this.notAddedPos.isEmpty()) {
                Iterator<DataPos> iter = this.notAddedPos.iterator();
                while (iter.hasNext()) {
                    DataPos dataPos1 = iter.next();
                    if (this.energy.getEnergy() < 50.0) continue;
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.func_177230_c() == Blocks.field_150346_d) {
                        if (random.nextInt(100) >= 90) {
                            this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(1));
                            this.dataPos.add(dataPos1);
                        }
                    } else if (dataPos1.state.func_177230_c() == Blocks.field_150351_n) {
                        if (random.nextInt(100) >= 94) {
                            this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(2));
                            this.dataPos.add(dataPos1);
                        }
                    } else if (dataPos1.state.func_177230_c() == Blocks.field_150354_m && random.nextInt(100) >= 80) {
                        this.field_145850_b.func_175656_a(dataPos1.getPos(), IUItem.ore2.func_176203_a(0));
                        this.dataPos.add(dataPos1);
                    }
                    iter.remove();
                }
                this.block_Col = this.dataPos.size();
                this.work = false;
                this.indexChunk = this.max;
            } else {
                this.work = false;
                this.indexChunk = this.max;
            }
        }
    }

    public ContainerEarthController getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerEarthController(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiEarthController(this.getGuiContainer(var1));
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.earthChestList.clear();
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IAnalyzer.class);
        this.analyzer = (IAnalyzer)this.func_145831_w().func_175625_s(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IEarthChest.class);
        for (BlockPos pos3 : pos2) {
            this.earthChestList.add((IEarthChest)this.func_145831_w().func_175625_s(pos3));
        }
        this.map = this.analyzer.getChunkPoses();
        this.chunkPosList = new ArrayList<ChunkPos>(this.map.keySet());
        List<BlockPos> pos3 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRigDrill.class);
        this.quarry = (IRigDrill)this.func_145831_w().func_175625_s(pos3.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }

    public Energy getEnergy() {
        return this.energy;
    }
}

