/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.graphite.capacitor;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.container.ContainerCapacitor;
import com.denfop.gui.GuiCapacitor;
import com.denfop.invslot.InvSlot;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.graphite.ICapacitor;
import com.denfop.tiles.reactors.graphite.ICapacitorItem;
import com.denfop.tiles.reactors.graphite.controller.TileEntityMainController;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCapacitor
extends TileEntityMultiBlockElement
implements ICapacitor,
IUpdatableTileEvent {
    private final int level;
    private final InvSlot slot;
    public double percent = 1.0;
    private int x = 0;
    private ICapacitorItem item;

    public TileEntityCapacitor(int level) {
        this.level = level;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.CAPACITOR;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ICapacitorItem && ((ICapacitorItem)stack.func_77973_b()).getLevel() <= ((TileEntityCapacitor)this.base).getBlockLevel();
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (!((TileEntityCapacitor)TileEntityCapacitor.this).field_145850_b.field_72995_K) {
                    if (content.func_190926_b()) {
                        ((TileEntityCapacitor)this.base).percent = 1.0;
                    } else {
                        ((TileEntityCapacitor)this.base).percent = 1.0 - ((ICapacitorItem)content.func_77973_b()).getPercent();
                        TileEntityCapacitor.this.item = (ICapacitorItem)content.func_77973_b();
                    }
                }
            }
        };
        this.slot.setStackSizeLimit(1);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.x);
        customPacketBuffer.writeDouble(this.percent);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.x = customPacketBuffer.readInt();
        this.percent = customPacketBuffer.readDouble();
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.percent = this.getSlot().get().func_190926_b() ? 1.0 : 1.0 - ((ICapacitorItem)this.getSlot().get().func_77973_b()).getPercent();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getMain() != null) {
            TileEntityMainController controller = (TileEntityMainController)this.getMain();
            if (controller.work && !this.slot.isEmpty() && this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
                if (this.item == null) {
                    this.item = (ICapacitorItem)this.slot.get().func_77973_b();
                }
                this.item.damageItem(this.slot.get(), -1);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.x = nbtTagCompound.func_74762_e("capacitor_x");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("capacitor_x", this.x);
        return nbtTagCompound;
    }

    @Override
    public int getBlockLevel() {
        return this.level;
    }

    public InvSlot getSlot() {
        return this.slot;
    }

    @Override
    public double getPercent(int x) {
        if (this.getMain() == null || x != this.x || this.getSlot().isEmpty()) {
            return 1.0;
        }
        return this.percent;
    }

    public ContainerCapacitor getGuiContainer(EntityPlayer var1) {
        return new ContainerCapacitor(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiCapacitor(this.getGuiContainer(var1));
    }

    public int getX() {
        return this.x;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (this.getMain() == null) {
            return;
        }
        IGraphiteReactor reactor = (IGraphiteReactor)this.getMain();
        if (var2 == 0.0) {
            this.x = Math.min(this.x + 1, reactor.getWidth() - 1);
            reactor.updateDataReactor();
        } else {
            this.x = Math.max(0, this.x - 1);
            reactor.updateDataReactor();
        }
    }
}

