/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.graphite.exchanger;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.container.ContainerExchanger;
import com.denfop.gui.GuiExchanger;
import com.denfop.invslot.InvSlot;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.graphite.IExchanger;
import com.denfop.tiles.reactors.graphite.IExchangerItem;
import com.denfop.tiles.reactors.graphite.controller.TileEntityMainController;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityExchanger
extends TileEntityMultiBlockElement
implements IExchanger,
IUpdatableTileEvent {
    public final int level;
    private final InvSlot slot;
    public double percent = 1.0;
    private int x = 0;
    private IExchangerItem item;

    public TileEntityExchanger(int level) {
        this.level = level;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.EXCHANGE;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof IExchangerItem && ((IExchangerItem)stack.func_77973_b()).getLevel() <= ((TileEntityExchanger)this.base).getBlockLevel();
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (!((TileEntityExchanger)TileEntityExchanger.this).field_145850_b.field_72995_K) {
                    if (content.func_190926_b()) {
                        ((TileEntityExchanger)this.base).percent = 1.0;
                    } else {
                        ((TileEntityExchanger)this.base).percent = 1.0 - ((IExchangerItem)content.func_77973_b()).getPercent();
                        TileEntityExchanger.this.item = (IExchangerItem)content.func_77973_b();
                    }
                }
            }
        };
        this.slot.setStackSizeLimit(1);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getMain() != null) {
            TileEntityMainController controller = (TileEntityMainController)this.getMain();
            if (controller.work && !this.slot.isEmpty() && this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
                if (this.item == null) {
                    this.item = (IExchangerItem)this.slot.get().func_77973_b();
                }
                this.item.damageItem(this.slot.get(), -1);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.percent = this.getSlot().get().func_190926_b() ? 1.0 : 1.0 - ((IExchangerItem)this.getSlot().get().func_77973_b()).getPercent();
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.x);
        customPacketBuffer.writeDouble(this.percent);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.x = customPacketBuffer.readInt();
        this.percent = customPacketBuffer.readDouble();
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.x = nbtTagCompound.func_74762_e("exchanger_x");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("exchanger_x", this.x);
        return nbtTagCompound;
    }

    @Override
    public int getBlockLevel() {
        return this.level;
    }

    public InvSlot getSlot() {
        return this.slot;
    }

    @Override
    public double getPercent(int x) {
        if (this.getMain() == null || x != this.x || this.getSlot().isEmpty()) {
            return 1.0;
        }
        return this.percent;
    }

    public ContainerExchanger getGuiContainer(EntityPlayer var1) {
        return new ContainerExchanger(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiExchanger(this.getGuiContainer(var1));
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (this.getMain() == null) {
            return;
        }
        IGraphiteReactor reactor = (IGraphiteReactor)this.getMain();
        if (var2 == 0.0) {
            this.x = Math.min(this.x + 1, reactor.getWidth() - 1);
            reactor.updateDataReactor();
        } else {
            this.x = Math.max(0, this.x - 1);
            reactor.updateDataReactor();
        }
    }

    public int getX() {
        return this.x;
    }
}

