/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.graphite.graphite_controller;

import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.container.ContainerGraphiteController;
import com.denfop.gui.GuiGraphiteGraphiteController;
import com.denfop.invslot.InvSlot;
import com.denfop.items.resource.ItemCraftingElements;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.graphite.IGraphiteController;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGraphiteController
extends TileEntityMultiBlockElement
implements IGraphiteController,
IUpdatableTileEvent {
    public final InvSlot slot;
    private final int level;
    public double fuel;
    public int levelGraphite = 1;
    private int index;

    public TileEntityGraphiteController(int level) {
        this.level = level;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.func_77973_b() instanceof ItemCraftingElements)) {
                    return false;
                }
                if (!((TileEntityGraphiteController)TileEntityGraphiteController.this).field_145850_b.field_72995_K) {
                    int itemDamage = stack.func_77952_i();
                    switch (itemDamage) {
                        case 357: {
                            return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 0;
                        }
                        case 410: {
                            return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 1;
                        }
                        case 310: {
                            return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 2;
                        }
                        case 368: {
                            return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 3;
                        }
                    }
                }
                return false;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (!((TileEntityGraphiteController)TileEntityGraphiteController.this).field_145850_b.field_72995_K && content.func_190926_b()) {
                    ((TileEntityGraphiteController)this.base).fuel = 0.0;
                }
            }
        };
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int i) {
        this.index = i;
    }

    public double getFuel() {
        return this.fuel;
    }

    public InvSlot getSlot() {
        return this.slot;
    }

    public ContainerGraphiteController getGuiContainer(EntityPlayer var1) {
        return new ContainerGraphiteController(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiGraphiteGraphiteController(this.getGuiContainer(var1));
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.index);
        customPacketBuffer.writeDouble(this.fuel);
        customPacketBuffer.writeInt(this.levelGraphite);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.index = customPacketBuffer.readInt();
        this.fuel = customPacketBuffer.readDouble();
        this.levelGraphite = customPacketBuffer.readInt();
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.fuel = nbtTagCompound.func_74769_h("fuel");
        this.levelGraphite = nbtTagCompound.func_74762_e("levelGraphite");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74780_a("fuel", this.fuel);
        nbtTagCompound.func_74768_a("levelGraphite", this.levelGraphite);
        return nbtTagCompound;
    }

    @Override
    public int getBlockLevel() {
        return this.level;
    }

    @Override
    public ItemStack getGraphite() {
        return this.slot.get();
    }

    @Override
    public int getLevelGraphite() {
        return this.levelGraphite;
    }

    @Override
    public double getFuelGraphite() {
        return this.fuel;
    }

    @Override
    public void consumeFuelGraphite(double col) {
        this.fuel -= col;
    }

    @Override
    public void consumeGraphite() {
        if (!this.slot.get().func_190926_b()) {
            int itemDamage = this.slot.get().func_77952_i();
            this.slot.get().func_190918_g(1);
            switch (itemDamage) {
                case 357: {
                    this.fuel = 100.0;
                    break;
                }
                case 410: {
                    this.fuel = 500.0;
                    break;
                }
                case 310: {
                    this.fuel = 2500.0;
                    break;
                }
                case 368: {
                    this.fuel = 5000.0;
                }
            }
        } else {
            this.fuel = 0.0;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.levelGraphite = Math.max(1, this.levelGraphite);
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.levelGraphite = var2 == 0.0 ? Math.min(this.levelGraphite + 1, 5) : Math.max(1, this.levelGraphite - 1);
        if (this.getMain() != null) {
            IGraphiteReactor graphiteReactor = (IGraphiteReactor)this.getMain();
            graphiteReactor.updateDataReactor();
        }
    }
}

